% thesis.cls
%
% Copyright 2009/2010 Everett H. Kropf (kropf at math.wichita.edu), all rights reserved.
%
% Thesis document class file to try and match the WSU graduate school formatting guidelines
% (opinion of the guidelines deleted)
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{thesis}[2010/1/21 v1.1 WSU Thesis document class]
% $Id: thesis.cls,v 1.8 2010/01/21 20:35:12 ehkropf Exp $
\newcommand*{\@thesistype}{}
\DeclareOption{thesis}{\renewcommand*{\@thesistype}{Thesis}}
\DeclareOption{dissertation}{\renewcommand*{\@thesistype}{Dissertation}}
\ExecuteOptions{thesis}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{report}}
\ProcessOptions\relax
\LoadClass{report}
%
\RequirePackage{indentfirst}
\RequirePackage{fancyhdr}
\RequirePackage{afterpage}
%
\renewcommand*{\chaptername}{CHAPTER}
\renewcommand*{\contentsname}{TABLE OF CONTENTS}
\renewcommand*{\listfigurename}{LIST OF FIGURES}
\renewcommand*{\listtablename}{LIST OF TABLES}
\renewcommand*{\abstractname}{ABSTRACT}
\renewcommand*{\bibname}{REFERENCES}
\newcommand*{\biblabel}{REFERENCES}
\renewcommand*{\appendixname}{APPENDIX}
\newcommand*{\appendixlabel}{\appendixname}
\newcommand*{\dedicationname}{DEDICATION}
\newcommand*{\acknowledgementname}{ACKNOWLEDGEMENTS}
\newcommand*{\prefacename}{PREFACE}
%
\newlength{\li} \setlength{\li}{1\@ptsize pt}
\setlength{\topmargin}{0pt}
\setlength{\headheight}{0pt}
\setlength{\headsep}{0pt}
\setlength{\topskip}{1\li}
\setlength{\textheight}{9in}
\setlength{\textwidth}{6.5in}
\setlength{\oddsidemargin}{0pt}
\setlength{\footskip}{30pt}
%
\setlength{\parindent}{.5in}
\newcommand*{\singlespace}{\baselineskip 1.1\li}
\newcommand*{\doublespace}{\baselineskip 2.0\li}
\brokenpenalty=501
\clubpenalty=501
\widowpenalty=10001
\setcounter{topnumber}{3}
\setcounter{bottomnumber}{2}
\renewcommand\topfraction{0.9}
\renewcommand\bottomfraction{0.9}
\renewcommand\textfraction{0}
\renewcommand{\arraystretch}{1.5}
\renewcommand{\headrulewidth}{0pt}
\setlength{\floatsep}{3\li}
\setlength{\textfloatsep}{3\li}
\setlength{\intextsep}{2\li}
%
% copied from chngpage.sty
\newcommand{\ch@ngetext}{%
  \setlength{\@colht}{\textheight}\setlength{\@colroom}{\textheight}%
  \setlength{\vsize}{\textheight}\setlength{\columnwidth}{\textwidth}%
  \setlength{\hsize}{\columnwidth}%
  \setlength{\linewidth}{\hsize}%
}
%
\newcommand*{\advisor}[1]{\renewcommand{\@advisor}{#1}} \newcommand*{\@advisor}{}
\newcommand*{\degree}[1]{\renewcommand{\@degree}{#1}} \newcommand*{\@degree}{}
\newcommand*{\major}[1]{\renewcommand{\@major}{#1}} \newcommand*{\@major}{}
\newcommand*{\prevdegree}[1]{\renewcommand{\@prevdegree}{#1}} \newcommand*{\@prevdegree}{}
\newcommand*{\dept}[1]{\renewcommand{\@dept}{#1}} \newcommand*{\@dept}{}
\def\submitdate#1{\gdef\@submitdate{#1}}
\def\copyrightyear#1{\gdef\@copyrightyear{#1}} 
\def\@submitdate
{ \ifcase\the\month\or
    January\or February\or March\or April\or May\or June\or
    July\or August\or September\or October\or November\or December
  \fi
  \space \number\the\year
}
\ifnum\month=12
  \@tempcnta=\year \advance\@tempcnta by 1
  \edef\@copyrightyear{\number\the\@tempcnta}
\else
  \def\@copyrightyear{\number\the\year}
\fi

\renewcommand*{\maketitle}
{ \newpage
  \pagenumbering{alph}\setcounter{page}{1}
  \thispagestyle{empty}%
  \singlespace
  \begin{center}
    {{\uppercase\expandafter{\@title}}}
  \end{center}
  \vfill
  \begin{center}
    \doublespace
    \rm  A {\@thesistype} by\par\noindent
    \@author\par\noindent
    {\@prevdegree}
  \end{center}
  \vfill
  \begin{center}
    { \vskip \li
      \singlespace
     Submitted to the Department of {\@dept}\\
     and the faculty of the Graduate School of\\
     Wichita State University\\
     in partial fulfillment of\\
     the requirements for the degree of\\
     {\@degree}\\}
  \end{center}
  \vfill
  \begin{center}
    \rm \@submitdate
  \end{center}
}
\newcommand*{\makecopyright}
{ \newpage
  \pagenumbering{alph}\setcounter{page}{2}
  \thispagestyle{empty}%
  \vspace*{3in}
  \begin{center}
    \doublespace
    {\normalsize \copyright\ Copyright {\@copyrightyear} by {\@author}} \\
    {\normalsize All Rights Reserved}
  \end{center}
}
\newcommand*{\frontmatter}
{ \clearpage
  \pagenumbering{roman}
  \setcounter{page}{3}
}
\newcommand*{\@abslikenv}[1]
{ \clearpage
  \begin{center}{ #1}\end{center}
  \vspace{2\li}
  \doublespace
  \hspace*{\parindent}\hspace{-0.4em}%
}
% currently setup to handle the length of 'College of Liberal Arts and Sciences',
% the longest college name at WSU in a 12pt font, but \pompousfactor can shorten/
% lengthen this
\newcommand*{\@scaleby}{1} \newcommand*{\pompousfactor}[1]{\renewcommand{\@scaleby}{#1}}
\newlength{\@siglinelen} \setlength{\@siglinelen}{3.9in}
\newcommand*{\@siglinewt}{0.4pt}
\newcommand*{\chairsignature}[1]
{ \noindent\rule{\@scaleby\@siglinelen}{\@siglinewt}\par
  \noindent\makebox[\@scaleby\@siglinelen]{{#1}, Committee Chair\hfill}\par
  \vspace{6ex}
}
\newcommand*{\signature}[1]
{ \noindent\rule{\@scaleby\@siglinelen}{\@siglinewt}\par
  \noindent\makebox[\@scaleby\@siglinelen]{{#1}, Committee Member\hfill}\par
  \vspace{3ex}
}
\newcommand*{\dissertationsigs}[3]
{ \vfill
  \hfill
  \parbox{\@scaleby\@siglinelen}
  { \noindent Accepted for the #1\par
    \vspace{4ex}
    \noindent \rule{\@scaleby\@siglinelen}{\@siglinewt}\par
    \noindent #2, Interim Dean\hfill\par
    \vspace{1.5\li}
    \noindent Accepted for the Graduate School\par
    \vspace{4ex}
    \noindent \rule{\@scaleby\@siglinelen}{\@siglinewt}\par
    \noindent #3, Interim Dean\hfill\par}
  \vfill
}
\newenvironment*{signaturepage}
{ \newpage
  \singlespace
  \begin{center}
  {{\uppercase\expandafter{\@title}}}
  \end{center}
  \vspace*{2\li}
  \rm\noindent The following faculty members have examined the final copy of this \MakeLowercase{\@thesistype} for form and content, and recommend that it be accepted in partial fulfillment of the requirement for the degree of {\@degree} with a major in {\@major}.\par
  \vspace{8ex}
}

\newenvironment*{dedication}
{\newpage\singlespace\begin{center}{ \dedicationname}\par\vspace{1.75in}}
{\end{center}}

\newenvironment*{epigraph}
{\newpage\vspace*{2in}\singlespace\begin{center}}
{\end{center}}

\newenvironment*{acknowledgements}{\@abslikenv{\acknowledgementname}}%

\renewenvironment*{abstract}{\@abslikenv{\abstractname}}%

\newenvironment*{preface}{\@abslikenv{\prefacename}}%

\newcommand*{\mainmatter}
{ \clearpage
  \setlength{\headheight}{0pt}
  \setlength{\headsep}{0pt}
  \setlength{\textheight}{9in}
  \ch@ngetext
  \pagenumbering{arabic}
  \setcounter{page}{1}
  \doublespace
  \pagestyle{plain}
}
\def\@chapter[#1]#2 % modified from report.cls
{
  \ifnum \c@secnumdepth >\m@ne
    \refstepcounter{chapter}%
    \typeout{\@chapapp\space\thechapter.}%
    \addcontentsline{toc}{chapter}{\protect\numberline{\thechapter}#1}%
  \else
    \addcontentsline{toc}{chapter}{#1}%
  \fi
  \@makechapterhead{#2}%
  \@afterheading
}
\def\@appendix[#1]#2
{ \refstepcounter{chapter}%
  \typeout{\@chapapp\space\thechapter.}%
  \addcontentsline{toc}{appendix}{\protect\numberline{\thechapter}#1}%
  \lhead{}\chead{\normalsize\@chapapp\space \thechapter}\rhead{}
  \lfoot{}\cfoot{\normalsize\thepage}\rfoot{}
  \afterpage{\chead{\normalsize\@chapapp\space \thechapter\space (continued)}}
  \@makeappendixhead{#2}%
  \@afterheading
}
\renewcommand{\@makechapterhead}[1]
{ \begin{center}
    \normalfont
    \ifnum \c@secnumdepth >\m@ne
      \normalsize\@chapapp\space \thechapter
      \par\nobreak
      \vspace{\li}
    \fi
    \interlinepenalty\@M
    \normalsize #1\par\nobreak
  \end{center}
  \vspace{2\li}
}
\newcommand{\@makeappendixhead}[1]
{\begin{center}\normalsize #1\end{center}\vspace{2\li}}
\renewcommand{\@makeschapterhead}[1]
{ \begin{center}
    \normalfont
    \interlinepenalty\@M
    \normalsize  #1\par\nobreak
  \end{center}
  \vspace{2\li}
}
\newcommand\th@chapter{\clearpage
  \global\@topnum\z@
  \@afterindentfalse
  \secdef\@chapter\@schapter}
\renewcommand*{\appendix}
{ \chapter*{\vspace*{\fill}\appendixlabel\vfill}
  \addtocontents{toc}{\protect\vspace{-\li}} 
  \addcontentsline{toc}{chapter}{\appendixlabel}
  \clearpage
  \setlength{\headheight}{1.3\li}
  \setlength{\headsep}{2\li}
  \addtolength{\textheight}{-3.3\li}
  \ch@ngetext
  \let\@chapter\@appendix
  \let\chapter\th@chapter
  \setcounter{chapter}{0}%
  \setcounter{section}{0}%
  \renewcommand*{\@chapapp}{\appendixname}%
  \renewcommand*{\thechapter}{\@Alph\c@chapter}
  \pagestyle{fancy}
}
\newcommand*{\appendices}{\renewcommand*{\appendixlabel}{APPENDICES}\appendix}
\renewcommand*{\section}{\@startsection{section}{1}{\z@}
                                     {.4\li plus .2\li minus .08\li}
                                     {.4\li plus .1\li}
                                     {\normalfont}}
\renewcommand*{\subsection}{\@startsection{subsection}{2}{\z@}%
                                     {.4\li plus .2\li minus .08\li}
                                     {.4\li plus .1\li}
                                     {\normalfont}}
\renewcommand*{\subsubsection}{\@startsection{subsubsection}{3}{\z@}%
                                     {.4\li plus .2\li minus .08\li}
                                     {.4\li plus .1\li}
                                     {\normalfont}}
%
\renewcommand*{\l@chapter}[2] % modified from report.cls
{ \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vspace \li
    \begingroup
      \@dottedtocline{0}{0.0em}{1.5em}{#1}{#2}
      \vspace \li
      \penalty\@highpenalty
    \endgroup
  \fi }
\providecommand*{\toclevel@appendix}{0}
\newcommand*{\l@appendix}        {\@dottedtocline{0}{1.5em}{2.3em}}
\renewcommand*{\l@section}       {\@dottedtocline{1}{1.5em}{2.3em}}
\renewcommand*{\l@subsection}    {\@dottedtocline{2}{3.8em}{3.2em}}
\renewcommand*{\l@subsubsection} {\@dottedtocline{3}{7.0em}{4.1em}}
\renewcommand*{\l@paragraph}     {\@dottedtocline{4}{9em}{5em}}
\renewcommand*{\l@subparagraph}  {\@dottedtocline{5}{11em}{6em}}
\renewcommand*{\l@figure}        {\@dottedtocline{1}{0.0em}{2.7em}}
\renewcommand*{\l@table}         {\@dottedtocline{1}{0.0em}{2.3em}}
%
\newcommand*{\@tocpagedimen}
{ \setlength{\headheight}{4.4\li}
  \setlength{\headsep}{1\li}
  \addtolength{\textheight}{-5.4\li}
  \ch@ngetext%
}
\newcommand*{\@tochead}[2]
{ \lhead{}\chead{\normalsize{ #1}\\\vspace{2\li}{#2}\hfill{Page}}\rhead{}
  \lfoot{}\cfoot{\normalsize\thepage}\rfoot{}
  \pagestyle{fancy}
  \afterpage{\chead{\normalsize{ #1\space (continued)}\\\vspace{2\li}{#2}\hfill{Page}}}
}
\renewcommand*{\tableofcontents}
{\clearpage\@tocpagedimen\@tochead{\contentsname}{Chapter}\@starttoc{toc}}
\renewcommand*{\listoftables}
{\clearpage\@tochead{\listtablename}{Table}\doublespace\@starttoc{lot}}
\renewcommand*{\listoffigures}
{\clearpage\@tochead{\listfigurename}{Figure}\doublespace\@starttoc{lof}}
\renewenvironment*{thebibliography}[1]
{ \chapter*{\vspace*{\fill}\biblabel\vspace{\fill}}
  \addcontentsline{toc}{chapter}{\biblabel}
  \clearpage
  \setlength{\headheight}{1.3\li}
  \setlength{\headsep}{2\li}
  \addtolength{\textheight}{-3.3\li}
  \ch@ngetext
  \lhead{}\chead{\bibname}\rhead{}
  \lfoot{}\cfoot{\normalsize\thepage}\rfoot{}
  \pagestyle{fancy}
  \afterpage{\chead{\bibname\space (continued)}}
  \list{\@biblabel{\@arabic\c@enumiv}}%
   {\settowidth\labelwidth{\@biblabel{#1}}%
    \leftmargin\labelwidth
    \advance\leftmargin\labelsep
    \singlespace
    \itemsep \li
    \@openbib@code
    \usecounter{enumiv}%
    \let\p@enumiv\@empty
    \renewcommand\theenumiv{\@arabic\c@enumiv}}%
  \sloppy
  \clubpenalty4000
  \@clubpenalty \clubpenalty
  \widowpenalty4000%
  \sfcode`\.\@m}
{\clearpage}

\endinput
