(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     26669,        615]
NotebookOptionsPosition[     26088,        593]
NotebookOutlinePosition[     26464,        610]
CellTagsIndexPosition[     26421,        607]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"2", 
   RowBox[{"x", "^", "2"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"6", "x"}], "-", "4"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"t", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"4", "x"}], "-", "2"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gg", " ", "=", " ", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"g", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.5"}], ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.75"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", "Thick", "}"}]}], ",", 
      RowBox[{"PlotLabels", "\[Rule]", 
       RowBox[{"Placed", "[", 
        RowBox[{"\"\<f(x)\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0.25", ",", "1"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Bold"}], "}"}]}], ",", 
      RowBox[{"Ticks", "->", "None"}]}], "]"}]}], ";"}], 
  "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh", "=", " ", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"h", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.5"}], ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.75"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Purple"}], "}"}]}], ",", 
      RowBox[{"PlotLabels", "\[Rule]", 
       RowBox[{"Placed", "[", 
        RowBox[{"\"\<Secant\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"2.5", ",", "9"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Purple", ",", "Bold"}], "}"}]}], ",", 
      RowBox[{"Ticks", "->", "None"}]}], "]"}]}], ";"}], 
  "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gt", "=", " ", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"t", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.5"}], ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.75"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Red"}], "}"}]}], ",", 
      RowBox[{"PlotLabels", "\[Rule]", 
       RowBox[{"Placed", "[", 
        RowBox[{"\"\<Tangent\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"2.5", ",", "6.5"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Red", ",", "Bold"}], "}"}]}], ",", 
      RowBox[{"Ticks", "->", "None"}]}], "]"}]}], ";"}], "  ", 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gg", ",", "gh", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Dotted", ",", "Black", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", " ", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*
StyleBox[\"(\",
FontSize->16]\)1, f(1)\!\(\*
StyleBox[\")\",
FontSize->16]\)\>\"", ",", "10"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.2", ",", 
          RowBox[{
           RowBox[{"g", "[", "1", "]"}], "-", "0.5"}]}], "}"}]}], "]"}]}], 
     "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Dotted", ",", "Black", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "8"}], "}"}], "]"}], ",", " ", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*
StyleBox[\"(\",
FontSize->16]\)2, f(2)\!\(\*
StyleBox[\")\",
FontSize->16]\)\>\"", ",", "10"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"2.2", ",", 
          RowBox[{
           RowBox[{"g", "[", "2", "]"}], "-", "0.5"}]}], "}"}]}], "]"}]}], 
     "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Black", ",", " ", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<Secant Line of f(x)\\n for the points (1,2) and (2,8)\>\"", ",",
           "Bold", ",", "13"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "9"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"gg", ",", "gt", ",", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Dotted", ",", "Black", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", " ", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*
StyleBox[\"(\",
FontSize->16]\)1, f(1)\!\(\*
StyleBox[\")\",
FontSize->16]\)\>\"", ",", "10"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.2", ",", 
          RowBox[{
           RowBox[{"g", "[", "1", "]"}], "-", "0.5"}]}], "}"}]}], "]"}]}], 
     "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Black", ",", " ", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<Tangent Line of f(x) \\nat x=1\>\"", ",", "Bold", ",", "13"}], 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "9"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.790997884640376*^9, 3.7909980802158127`*^9}, {
  3.790998226482647*^9, 3.790998259000338*^9}, {3.790998295240733*^9, 
  3.7909983247859364`*^9}, {3.790998359637814*^9, 3.790998874081566*^9}, {
  3.790998931189908*^9, 3.7909990036209183`*^9}, {3.7909990814101343`*^9, 
  3.79099916765268*^9}, {3.790999202374916*^9, 
  3.790999202635787*^9}},ExpressionUUID->"ae26de14-abcd-4f58-b474-\
223b35878232"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
       LineBox[CompressedData["
1:eJwdloc3Ff7/x6+dLWSmiJCPUeQTGa9rRaIoIyuSMiqjLqnMbEJ2RpQr2TNZ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        "]]},
      Annotation[#, "Charting`Private`Tag$725099#1"]& ]}, {{}, {{}, InsetBox[
       StyleBox["\<\"f(x)\"\>",
        StripOnInput->False,
        LineColor->RGBColor[0, 0, 1],
        FrontFaceColor->RGBColor[0, 0, 1],
        BackFaceColor->RGBColor[0, 0, 1],
        GraphicsColor->RGBColor[0, 0, 1],
        FontWeight->Bold,
        FontColor->RGBColor[0, 0, 1]], {0.25, 1.}, 
       ImageScaled[{0.5, 0.5}]]}}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.5, 0, 0.5], Thickness[Large], Opacity[1.], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQHRYKAg/tGcDgxf77KR2Zum0P7U8sOtv2/taz/Vti
O8UXOz+xVzCXP711xcn9r6+uMA/+8syegf3V7GfFl+09m/j+nC17ab+DN/zF
5RMv7BtdnM8l6b+xbzl7Mkuj74v9A6t9Lod2vrNfsMHqnJvuH/vAG6vF1s3+
YP+lg9mF6zKjg7zcA8GOrx/tY6IWmM54wOrAUGce727x2Z6hapnstRWcDucy
yjYLT/tin2WVLGV9iNfBb/IRh9q3X+2/3FF7aP1EwOHhdVOFM7rf7S8dDjDY
dETIIXF5H5tG5w97od9XOfecFXH4MoHLPvPsT/u8m/33ZLeIOVjumrrBnfu3
fdj0Bx2vJ0g4ZOVxaBqn/LFfsLRnr880KYf1NvM+My/7a88WnfuWtVLG4eFU
6aMPmf7bX0pYuTyoRc5hMktcSZAKg8Mdtt511WYKDnz3ti5iOsLgIHpW4Auz
mqIDQ21jiGUho0OD9aF/VzWVHH6viFv/SIjJoeIvL3uIjLLDKjBgcoCEt4oD
AJw6sD4=
        "]]},
      Annotation[#, "Charting`Private`Tag$725188#1"]& ]}, {{}, {{}, InsetBox[
       StyleBox["\<\"Secant\"\>",
        StripOnInput->False,
        LineColor->RGBColor[0.5, 0, 0.5],
        FrontFaceColor->RGBColor[0.5, 0, 0.5],
        BackFaceColor->RGBColor[0.5, 0, 0.5],
        GraphicsColor->RGBColor[0.5, 0, 0.5],
        FontWeight->Bold,
        FontColor->RGBColor[0.5, 0, 0.5]], {2.5, 9.}, 
       ImageScaled[{0.5, 0.5}]]}}, {{}, {}}}, 
   {GrayLevel[0], PointSize[Large], Thickness[Large], Dashing[{0, Small}], 
    PointBox[{1, 2}], InsetBox[
     StyleBox["\<\"\\!\\(\\*\\nStyleBox[\\\"(\\\",\\nFontSize->16]\\)1, \
f(1)\\!\\(\\*\\nStyleBox[\\\")\\\",\\nFontSize->16]\\)\"\>",
      StripOnInput->False,
      FontSize->10], {1.2, 1.5}]}, 
   {GrayLevel[0], PointSize[Large], Thickness[Large], Dashing[{0, Small}], 
    PointBox[{2, 8}], InsetBox[
     StyleBox["\<\"\\!\\(\\*\\nStyleBox[\\\"(\\\",\\nFontSize->16]\\)2, \
f(2)\\!\\(\\*\\nStyleBox[\\\")\\\",\\nFontSize->16]\\)\"\>",
      StripOnInput->False,
      FontSize->10], {2.2, 7.5}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Secant Line of f(x)\\n for the points (1,2) and (2,8)\"\>",
      
      StripOnInput->False,
      FontSize->13,
      FontWeight->Bold], {1, 9}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->{
    RGBColor[0, 0, 1], Bold},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.5, 3}, {-0.75, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{{}, {}}]], "Output",
 CellChangeTimes->{
  3.790998082331908*^9, 3.790998228355214*^9, 3.790998262641245*^9, 
   3.79099832736228*^9, 3.7909983910066643`*^9, {3.790998440984179*^9, 
   3.790998592987709*^9}, 3.790998797946814*^9, {3.790998849036392*^9, 
   3.790998876069067*^9}, {3.790999006196213*^9, 3.79099906151803*^9}, {
   3.790999094180032*^9, 3.790999138146043*^9}, 3.790999169596678*^9, 
   3.7909992044802923`*^9},ExpressionUUID->"1bed4f01-e198-4693-80fc-\
220e839fb465"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
       LineBox[CompressedData["
1:eJwdloc3Ff7/x6+dLWSmiJCPUeQTGa9rRaIoIyuSMiqjLqnMbEJ2RpQr2TNZ
5W27uPbel1JklV3G/X5+v+c5z/M8j/P8Bx5Cti7X71JiMJjN//p/a+kjOUgm
r6HN/Zs5ZDIZpte12Ta21lDsRp7O4hIZbOzv6H1fWkOcO3sKYyNkuGuQ0kwc
WUNNIqn0xGIyOJ86UpFcvIaIfN1OB9Zk8G/9miBnvYbC3GilohsOIZsl1dS+
bhXlt9eXOIcdwK90+olurxWUImJZISC5B3m53IMBTT8Rt5Nzu43tNqj4zYg7
KyygvhCz+iPG6+A8Esp4omYeWXQzjlH5r0ALzx1SOc1XVNmnohL55jtsnd5h
8/UloY7PTNzblLPQr/hiKBJHQsKZQVUPlklQos+ckub433/F23B9iARO7sLC
NTdIaH9pwVEilwSk5mvyW2L/sXXp+asGJEhoMygffjuDGiVZ7AjqM4DVKNcs
Vp9G4U8jkuLeTELSRU97m+AJtDhzcme7YARMnA+Of3OdQPcr2M6zho4AV+aL
fnuLCXQ0huGK5p0RSKSPVHE5O4GazHnpaPhGIH70HYfP+Diqu4CvJIUOQ4xH
J0qVHkdCPA5/MQ+GIKLsBM/I8CiKe/SJdl57AHS/47vMG0aRJRMh8LXoADDw
nQmYzh9FlwvmJh1oBiDcX2513m8UhR/K8ts09UOogU7zpsQoylyG3hxsPwSt
urmy+44g7BrDcTy2D3wlWgj6YsNI/3gnzqOgG9Ilxc9ocAyjC8Ids6zu3fBZ
OiJMgTyEXppsBUyodMOurKGu8MgQ8lfvtafv7YJHSlOdu8FDKEPmdSHaJsI9
va1u/PdBFHXL9VyififoOZ8e+vN+ACmzqvMtCRLAyTVUfi1mAP3Ct0p2rrVB
2KOlhG/eA4jr7hPcVF0btHqUmvQYD6C8B1b411ZtAL4qo1k0A2j/lZKv45tW
kH1lPHHtbj8yk8bKuIu2AG9Z0Ox7kT70o9bJ9fytRghVeub2k6UPtUQN8dTL
NMJuszOFzJ9exHIR1xFM0QijI6ZCVV29aIhX/3LL+wZIPDhzu8OjFykdPqig
/V0Pp2PTGqZietDPjx1R/55GwFMvVe8yTkQaDa5ZXNQ1sNPPRdotIqKffsrq
vyqqYXieTPYPICLr3y7r4FANCYz9EC9JRLXfmMPVuquA3dQDVfl0IrFjoold
GZXAtFpXRyHcgcbS2oTozSqAzG/wJe5+G8rT7qFlESmFtM5NWYxGG+K6dCx2
cqEEFJ4n5zzga0PMr6yp2YtK4NH4XJxWeyvC01KklyqWwPxrd6cd0VaE9ld1
Q/KLoPNYKrfFXDPSPXuX4Z56Pji0QGRbdTPKS39GQRrNA2r3b5TnY5qRYNbr
VjHXPFAdlFplwjYjC9xqjeC7XCiNrW+ue9OENs9Q6FUx5UAS63e3U2aNqG6x
kdWH4T2cR+E/os42ouz22z8GC7Og11nGao+uEWVh6SP/GGYBQ7enzuCnBrS6
4aZekIYH75eMJ4M5G9AHlzzjSqVMaGW3fT2QgZDVExclAjYDMI/yAwquIqTC
V58v8y4dFPs2nYMO6tCVJaEqWap0KIgO0bpgUYcOuHnfMxLTIJapcD2F6wsq
SB3qOeKWAta0u3q2kTVISS/E4eyRRChIOFgcUKlBbsH4vrXABPgrQhWitVqN
qC83d12kSoB4DZYG8WvVSN6ew/cxdTwQ/ETk19iq0DDdQosLbywcY5Pot2mo
RLOB4m0RmTFgmyHj0u9WiS6FP7SQk4qBgy8Xcyv6PyEhaRqV09qvQHbPQMAr
vgKJfRwiiPFHgm+4Sc2KZgX6Jpexx3PpJRB5LU2ttz4i02Y3IyFcBNgr2Meo
m3xEVtyynk/GwiDN3ZuGnqcczQWdDFVsDwaaX7krCaklaDKwsJ1TxR+u+xaH
0+mVoEXWI1aeyX4AAk7X1neLkZnpiOT3376AM/drqqopQniJtG2LF94wNViQ
r6VagKRtyXyPVzzBc6NyXjwjH6UGaGUWjDwBdvamk0yYfOTa+sadk+ABl66N
xfU35CKzkkCMSy0OStppvKy1PiDRY5Ifri27gu4C2yf17Gw0q0YVvUfnCvO0
x3+dpstGRwXHgvJvOAOfpqzdMiELiQotCUhg7sNHW5X0njNZaCVI4uqmgyNc
9dcZLQvHozCpKC7+aXsIqLul91QvE6lqNbr4rNjBiSnHYMvCd+hmRSymNuQO
VO3h6oHlHdJ0CDljJG0L425cjkxvM5CcVG2Igpo1sBZLTvXfTkc0Ij5OiaOW
oLmsbpgs/Ab5vA3zLgw1h8J7LoqiH1KQg8Sz83RyJrDJk549o5+McAdN206U
RqDcSeRI3kxCWWn1hYurhhDoved3PTURLbOSymh/XwOijMQqo3oCGvLJ2nBR
1QPOuZsWLQtxiDK4W4C1VQcs40MIPtGxCHf61rlvIVow+rtd62t1NNIxtzxj
gwNwMBETNKGLRK0SUwR944uwWxP4l2AUjrr+OaP0IU8eQk/ODSplhiArK6zf
A9w54AmE4qK1QLTko3VW6e4/kLOQFiak8gLJZL2lce8QAZeUzTbxY76IzliE
gvncCYi6U+zFUvIUDQqfV59J54QiSadzm7o4FO04m9bwmR5Sly4Tyzsfoqcn
HZIu1e2pjnsjeV+KO6hjwU8jKu67qpygk2qCswFijr7VKkqqV1VYyau5lnQe
hHf4taZ9w1V7EhG/So05SKasys1cH1YVV3QSuSHmAFUCggxSSuuquBvPppo8
3aCme69ahpMKjMOR+PSUB7iFvW3kMGWDfxuocbvqXpC34rJRt8UDjPtZ1vSD
fkDJ8KmSqVwInidpByUGB4C6j27q0UExWJL9mSesGAxxN9xFVqekwbL7ZW/J
UigcaKaeMXSQA6KjzLZKegRUsbVxcA9fAGWafv5OgyjYY6rr1alSBhODGsEC
/1fw7Tj27GM6NWBJjyhfH4+B6M7g2Z1lDWhdsrykeD4OfNjlvMqYtMFHUXrM
NzIeyn5rYvD3dOHfEPL91u8JIOH4+WH7X31YHew9ZMImAe6z3lzsNwPIPpUZ
cyP5NeDYnCknF64Dd51mJelKKkwfbxdEOqbQy8ilK/Y+DbSHKE+aZZlBqNmP
yYeHb6DPbO0oi4AleP3V9Pe++Ray7/xy+lZmA8sJP7IZGPGwksy+hM27BwRl
g1+FlXjIy/77+ameA2R9rVI0tMsCT15leuyBI1ieCycmfXkP2uc62dzDHwKR
KLku4poDY5zMzvW5jyDncYIS4XgueJXfq2eveAyBfIeB99tzQYxmpSe/DQfK
Dj3cZafy4XWDr2gZ5RMooHqkAkOFQEr/Usra+xxiLyzLGHsUgYQA+WoC2Qs8
7987dZ+7GN7HsHxylfeBTMfCgE7JEkgo6nTlNPeDh33vHHacS0EBxE17Dl+A
zdL07ReoFARGMPqLxQFwnea4BTNbGXA71YtJ2wWCgmKivnBpGZj5b0YoDAcB
9btw2Wsb5XCAO8tqQAqFnZq2f8Y1PkLmPFayIS8Mfg5Sn74b/xGsDRWkrTzD
ofeIL/dz+QoQ5JskHRN4CWmuj/ezn3yCJtcdTPjLaJDDWrYe7lWBerJqYp1/
HIiaJ6MwvWowyju8chUTDzy44SrON9XwS0EW99gvHg4/GORLqNZAX/cGv09Q
AnSwar0y8asFoSkSIT4zCWxnpMyLqOuAItD2dZt4Gugg8nZRcANYHlCEvJPF
Q4bKc06TsgYwqkjLqYnFw3bt9rmDqQaQ0DPdb9jAQ1bVyoMr8o3wiEvyYmpV
FmDKJuZ+fG2ExwJGrJ762VCdVdktqNYM/269OTmBzwWJcJfs2L1WmLrL9ADv
XwL+R5aaFMXaoKl45ERcfQmMBt+bJV1vA97Fsp9/yCUQHGB1XCavDdglkrsk
/UphzutKbOdNAijPi9SLBZdBiouYD/WndnDDKt58lPMRGI1njD1ciWAZbmxk
fqkabtZ68RmmEuGW8ygBxVZDthDfzD+tRFhpiqV5PVMN2FUjh1n+LnjfVDjy
9lkN4EI6num1dcGrY97THJ9qYbq6IuPUiR4wp/L38FWvAzPWVtyP+V4wpmJ1
+DTaAH6NnCNGe72wH9n2/hhtI2S731FsZOuDe32p2kVyjbA5gTlMU+qDqBdJ
lRHRjRCVoxRyPaYPuKMmdHYuN0GjWmnyF+V+OKWbeDamvRkkcWl1cXEDwGsy
zNm70QabN5k9oj8MwDMLUb8eEQJ8VvGRiqgdAByJeRhjQoArdDZpL74OgKwj
Xu1P1X++mSL8zE1uEKbcF7jV/Nshtz5P/trAIPx8Pl4vyd8JoszVBQwcwzB6
8RY1DtcNgtlDKf6xo0Ctvi5+e7ofEqkqTknnjMKWex1PNbkfmG/H541/GQWK
xnI7aaEB+Mt/o0ZucRTsMnmPutkNwFBM79g8jIF1YH+tyfJ/Pu7dyaO7MgbH
u3Zv4imGYNOoIZFdZwJq3LjL1NRHgEBVGIs/mIIwujczsfyTQIotcpk+Og37
/xAYI9QmYVeoRI9XdBoibTc70+wnQRxbTht9dRroaA2OMH+chBCv6mfPMqbB
RpTTTfDqFFzaarE1VJuBD8QeSo6QabB97JLsq06CFtPwOI5gEszYhTpKBc/C
FXun6qBzX+GjVRg3XuMb2O1e/CCftwhLQzkXbmx+h0MrtzmlJ7/g8guW/S6P
RegOEFs119gEf02NbluZZaAvs+OUG9gF0sU6zcbqVaBaqIl74XcAhqP5XEWp
v8DiZMXvSyoU2JMnSEdDt35D7EwWxVNxaizG54K1tsIGbBXte7hw0WG7HTzK
ORI34dL50+slXgzYq3HNWO+VLVDVfjIpxcyCnR2RFyRK7UAsj88frg427O0P
UbTiYbvw+2z9Al0vO3bzFQM4dv0BNpvrGP5uTqxiTUKJNuMeJBV832Ca4MI6
OR85I2e3D0uYWe24s7zYYuX0DarsA8gYjHqk6cmPnU3gb5mlJIPjtklJAvMJ
bBz1Ldx1EQxWP83VakdHEMsyXZFJ2YzBYuIOg+7FCGEx3v5Gim4UWN+LEiy1
VMLYfW4Vzpk5Cizm/yOC/R+atpJo
        "]]},
      Annotation[#, "Charting`Private`Tag$725099#1"]& ]}, {{}, {{}, InsetBox[
       StyleBox["\<\"f(x)\"\>",
        StripOnInput->False,
        LineColor->RGBColor[0, 0, 1],
        FrontFaceColor->RGBColor[0, 0, 1],
        BackFaceColor->RGBColor[0, 0, 1],
        GraphicsColor->RGBColor[0, 0, 1],
        FontWeight->Bold,
        FontColor->RGBColor[0, 0, 1]], {0.25, 1.}, 
       ImageScaled[{0.5, 0.5}]]}}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
       LineBox[CompressedData["
1:eJwtxQ0s1GEcwPG/u+PxUjeHUnk7HkS5tJW3WM9vpaiwke3a5Eh6QclLWRat
M25uE+Y9ZMtJpJyGTXZxM5q2GCFm3g5rDEXIO9Xu+W7ffSzDHgTcYjEM4/Lv
/6rrJ2pnWvmVA8XinCHy7E513kbjaGsn+32ObGeUKFWFkVMGytbx8PQIgURF
Fn0lRd/DOklDsNRYdn6a9CTYiDK4KjI3UOVydeUHeSeUjfn0zpFLKdztroRZ
ksMxWy9Z+E3Enue7wxznCUsqKe0QrZOJMy2ebR9/EuWjJGlq/A7xH6o5WFuy
SMrrhILrLhpgYT7BS19dImc9lFh/jg3MU5cQL9dlwmxHt2TGaEH33YR6w4IV
Uto7f/uogw745bZD8sIqKbWVijeH9UA16MT/KlgjbfIoKAriwo03mVp20nWi
Vh9WsnVJRNcGUcsDt+b8Oi+9LaLWECKjte1PhW8TtUYg9yhbZlfuELUHQJVv
0qFi7RG1xpDLET0MsGbAVkcxU+F9CLhjjeWsdgZMFVEXNNMPA5MsDnSL1QBm
k1UdN3kEtqpE8kkDFvzx/yTqsDGF+8Xy5wZtLBg+HWJik2oGTcfTtXnRbIgR
6vOsRsxh3+U4hxQuh8qHQUFPX6KCQ+VDTRmxnhZpUi3hmtyZZ7arSbWEJ2mv
xCNvtahWUDVjVsL1QVQMqS/TQsf8EBVDaMCCTa0/omIwVijqfIWIikGSFfQ5
IwxRMYQ7v1jSTURUDPxUI29UiagYtl2T9g9WISqGoYWpb5U1iIohS1gffPED
omLYPRYQn6ZAVAwjvVll7D5ExdAkWbvZN4CoGPLcQ+xlQ4iK4crrEw3nxhAV
Q/Pjri/iWUTFUCBwyvKfR1QMsZOlgZa/EBWDnc+9ceUKomLgaPRXZK8hKoaJ
RvfI0E1ExaCIlDme3EFUDIUWeqt7e4iK4S97EYVg
        "]]},
      Annotation[#, "Charting`Private`Tag$725277#1"]& ]}, {{}, {{}, InsetBox[
       StyleBox["\<\"Tangent\"\>",
        StripOnInput->False,
        LineColor->RGBColor[1, 0, 0],
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontWeight->Bold,
        FontColor->RGBColor[1, 0, 0]], {2.5, 6.500000000000001}, 
       ImageScaled[{0.5, 0.5}]]}}, {{}, {}}}, 
   {GrayLevel[0], PointSize[Large], Thickness[Large], Dashing[{0, Small}], 
    PointBox[{1, 2}], InsetBox[
     StyleBox["\<\"\\!\\(\\*\\nStyleBox[\\\"(\\\",\\nFontSize->16]\\)1, \
f(1)\\!\\(\\*\\nStyleBox[\\\")\\\",\\nFontSize->16]\\)\"\>",
      StripOnInput->False,
      FontSize->10], {1.2, 1.5}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Tangent Line of f(x) \\nat x=1\"\>",
      StripOnInput->False,
      FontSize->13,
      FontWeight->Bold], {1, 9}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->{
    RGBColor[0, 0, 1], Bold},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.5, 3}, {-0.75, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{{}, {}}]], "Output",
 CellChangeTimes->{
  3.790998082331908*^9, 3.790998228355214*^9, 3.790998262641245*^9, 
   3.79099832736228*^9, 3.7909983910066643`*^9, {3.790998440984179*^9, 
   3.790998592987709*^9}, 3.790998797946814*^9, {3.790998849036392*^9, 
   3.790998876069067*^9}, {3.790999006196213*^9, 3.79099906151803*^9}, {
   3.790999094180032*^9, 3.790999138146043*^9}, 3.790999169596678*^9, 
   3.7909992044929857`*^9},ExpressionUUID->"92327fd7-6883-43c7-9d64-\
e56d3e9d4863"]
}, Open  ]]
},
WindowSize->{1000, 722},
WindowMargins->{{65, Automatic}, {Automatic, 0}},
Magnification->1.25,
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 6890, 201, 705, "Input", "ExpressionUUID" -> \
"ae26de14-abcd-4f58-b474-223b35878232"],
Cell[7473, 225, 9271, 182, 312, "Output", "ExpressionUUID" -> \
"1bed4f01-e198-4693-80fc-220e839fb465"],
Cell[16747, 409, 9325, 181, 312, "Output", "ExpressionUUID" -> \
"92327fd7-6883-43c7-9d64-e56d3e9d4863"]
}, Open  ]]
}
]
*)

