(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     33804,        800]
NotebookOptionsPosition[     33245,        779]
NotebookOutlinePosition[     33601,        795]
CellTagsIndexPosition[     33558,        792]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "+", "2"}], ",", 
        RowBox[{"x", "<", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "+", "6"}], ",", 
        RowBox[{"x", ">", "1"}]}], "}"}]}], "}"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"gifs1", " ", "=", " ", 
  RowBox[{"Row", "[", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"l1", " ", "=", " ", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "2.5"}], ",", " ", "2"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "2.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "8.5"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", " ", 
         RowBox[{"PlotLabel", "\[Rule]", 
          RowBox[{"Style", "[", 
           RowBox[{
           "\"\<Limit of \\\"f(x)\\\" as \\\"x\\\" Approaches \\\"a\\\" From \
the Left\>\"", ",", " ", "Bold", ",", "15"}], "]"}]}], ",", 
         RowBox[{"Ticks", "->", "None"}]}], "]"}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"l2", " ", "=", " ", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "}"}], ",", "White", 
          ",", " ", 
          RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"l4", " ", "=", " ", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "7"}], "}"}], "]"}]}], "}"}], ",", "White", 
          ",", " ", 
          RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "7"}], "}"}], "]"}]}], "}"}], "]"}]}], ";", 
      RowBox[{"Animate", "[", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{"l1", ",", "l2", ",", "l4", ",", "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2.92"}], "}"}]}], "}"}], "]"}], ",", " ", 
             
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<a\>\"", ",", "15"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", 
                 RowBox[{"-", "0.18"}]}], "}"}]}], "]"}]}], "}"}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "3"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.95", ",", "3"}], "}"}]}], "}"}], "]"}], ",", " ", 
             
             RowBox[{"Text", "[", 
              RowBox[{"\"\<L\!\(\*
StyleBox[\"-\",
FontSize->12]\)\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "0.1"}], ",", "3.2"}], "}"}]}], "]"}]}], "}"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"t", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", 
                  RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], ",", 
             " ", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<a-\[Epsilon]\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"t", "-", "0.1"}], ",", 
                 RowBox[{"-", "0.25"}]}], "}"}]}], "]"}]}], "}"}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"f", "[", "t", "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", 
                  RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], ",", 
             " ", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<f(a-\[Epsilon])\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "0.25"}], ",", 
                 RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "]"}]}], "}"}], 
           "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "0.98"}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"r1", " ", "=", " ", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "2.5"}], ",", " ", "2"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "2.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", " ", 
         RowBox[{"PlotLabel", "\[Rule]", 
          RowBox[{"Style", "[", 
           RowBox[{
           "\"\<Limit of \\\"f(x)\\\" as \\\"x\\\" Approaches \\\"a\\\" From \
the Right\>\"", ",", " ", "Bold", ",", "14"}], "]"}]}], ",", 
         RowBox[{"Ticks", "->", "None"}]}], "]"}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"r2", " ", "=", " ", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "}"}], ",", "White", 
          ",", " ", 
          RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"r4", " ", "=", " ", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "7"}], "}"}], "]"}]}], "}"}], ",", "White", 
          ",", " ", 
          RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "7"}], "}"}], "]"}]}], "}"}], "]"}]}], ";", 
      RowBox[{"Animate", "[", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{"r1", ",", "r2", ",", "r4", ",", "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2.92"}], "}"}]}], "}"}], "]"}], ",", " ", 
             
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<a\>\"", ",", "15"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", 
                 RowBox[{"-", "0.18"}]}], "}"}]}], "]"}]}], "}"}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "3.15"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "6.9"}], "}"}]}], "}"}], "]"}]}], "}"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "7"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.95", ",", "7"}], "}"}]}], "}"}], "]"}], ",", " ", 
             
             RowBox[{"Text", "[", 
              RowBox[{"\"\<L\!\(\*
StyleBox[\"+\",
FontSize->12]\)\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "0.1"}], ",", "6.8"}], "}"}]}], "]"}]}], "}"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"2", "-", "t"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"2", "-", "t"}], ",", 
                  RowBox[{"f", "[", 
                   RowBox[{"2", "-", "t"}], "]"}]}], "}"}]}], "}"}], "]"}], 
             ",", " ", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<a+\[Epsilon]\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"2", "-", "t", "+", "0.1"}], ",", 
                 RowBox[{"-", "0.25"}]}], "}"}]}], "]"}]}], "}"}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"f", "[", 
                   RowBox[{"2", "-", "t"}], "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"2", "-", "t"}], ",", 
                  RowBox[{"f", "[", 
                   RowBox[{"2", "-", "t"}], "]"}]}], "}"}]}], "}"}], "]"}], 
             ",", " ", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<f(a+\[Epsilon])\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "0.25"}], ",", 
                 RowBox[{"f", "[", 
                  RowBox[{"2", "-", "t"}], "]"}]}], "}"}]}], "]"}]}], "}"}], 
           "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "0.98"}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"g1", " ", "=", " ", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "2.5"}], ",", " ", "2"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "2.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "8"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", " ", 
         RowBox[{"PlotLabel", "\[Rule]", 
          RowBox[{"Style", "[", 
           RowBox[{
           "\"\<Limit of \\\"f(x)\\\" as \\\"x\\\" Approaches \\\"a\\\"\\nThe \
Limit DNE\>\"", ",", " ", "Bold", ",", "16"}], "]"}]}], ",", 
         RowBox[{"Ticks", "->", "None"}]}], "]"}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"g2", " ", "=", " ", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "}"}], ",", "White", 
          ",", " ", 
          RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "}"}], "]"}]}], ";", " ",
       "\[IndentingNewLine]", 
      RowBox[{"g4", " ", "=", " ", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "7"}], "}"}], "]"}]}], "}"}], ",", "White", 
          ",", " ", 
          RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "7"}], "}"}], "]"}]}], "}"}], "]"}]}], ";", 
      RowBox[{"Animate", "[", 
       RowBox[{
        RowBox[{"Show", "[", 
         RowBox[{
         "g1", ",", "g2", ",", " ", "g4", ",", "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "0.1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2.92"}], "}"}]}], "}"}], "]"}], ",", " ", 
             
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<a\>\"", ",", "15"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", 
                 RowBox[{"-", "0.18"}]}], "}"}]}], "]"}]}], "}"}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "3"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.95", ",", "3"}], "}"}]}], "}"}], "]"}], ",", " ", 
             
             RowBox[{"Text", "[", 
              RowBox[{"\"\<L\!\(\*
StyleBox[\"-\",
FontSize->12]\)\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "0.1"}], ",", "3.2"}], "}"}]}], "]"}]}], "}"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1", ",", "3.15"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "6.9"}], "}"}]}], "}"}], "]"}], ",", " ", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<L\!\(\*
StyleBox[\"+\",
FontSize->12]\)\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "0.1"}], ",", "6.8"}], "}"}]}], "]"}]}], "}"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "7"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.95", ",", "7"}], "}"}]}], "}"}], "]"}]}], "}"}], 
           "]"}], ",", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"2", "-", "t"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"2", "-", "t"}], ",", 
                  RowBox[{"f", "[", 
                   RowBox[{"2", "-", "t"}], "]"}]}], "}"}]}], "}"}], "]"}], 
             ",", " ", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<a+\[Epsilon]\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"2", "-", "t", "+", "0.1"}], ",", 
                 RowBox[{"-", "0.25"}]}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"f", "[", 
                   RowBox[{"2", "-", "t"}], "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"2", "-", "t"}], ",", 
                  RowBox[{"f", "[", 
                   RowBox[{"2", "-", "t"}], "]"}]}], "}"}]}], "}"}], "]"}], 
             ",", " ", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<f(a+\[Epsilon])\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "0.25"}], ",", 
                 RowBox[{"f", "[", 
                  RowBox[{"2", "-", "t"}], "]"}]}], "}"}]}], "]"}]}], "}"}], 
           "]"}], ",", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"t", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", 
                  RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], ",", 
             " ", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<a-\[Epsilon]\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"t", "-", "0.1"}], ",", 
                 RowBox[{"-", "0.25"}]}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"f", "[", "t", "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", 
                  RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], ",", 
             " ", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<f(a-\[Epsilon])\>\"", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "0.25"}], ",", 
                 RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "]"}]}], "}"}], 
           "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "0.98"}], "}"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<LimJumpDis.gif\>\"", ",", "gifs1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.790124162542844*^9, 3.7901242605969954`*^9}, {
   3.790124316017997*^9, 3.7901243750205193`*^9}, {3.790124410136588*^9, 
   3.790124531358658*^9}, {3.79012457135316*^9, 3.790124643309168*^9}, {
   3.790124676563085*^9, 3.790124679565681*^9}, {3.790124714343642*^9, 
   3.7901247905815487`*^9}, {3.790124858787827*^9, 3.790124929286392*^9}, {
   3.790124972008831*^9, 3.790124983949965*^9}, {3.7901250782882357`*^9, 
   3.790125109264875*^9}, {3.790125142095786*^9, 3.790125185725842*^9}, {
   3.790125244180264*^9, 3.790125342182581*^9}, {3.7901254015644093`*^9, 
   3.7901254216729794`*^9}, {3.790125486279212*^9, 3.7901255320143833`*^9}, {
   3.790125573532686*^9, 3.7901256972548227`*^9}, {3.790125727809984*^9, 
   3.7901257617874603`*^9}, 3.790125815746035*^9, {3.790125880466939*^9, 
   3.79012614482545*^9}, {3.790126249160885*^9, 3.790126271126306*^9}, {
   3.7901263351360207`*^9, 3.7901263554683847`*^9}, {3.790126472792341*^9, 
   3.790126495180019*^9}, {3.7901266019570312`*^9, 3.790126614530875*^9}, {
   3.7901266498194113`*^9, 3.7901266592756557`*^9}, {3.79012669951611*^9, 
   3.790126744869032*^9}, {3.790126791278348*^9, 3.790126913176094*^9}, {
   3.790129096033676*^9, 3.790129188403113*^9}, {3.7901292358883257`*^9, 
   3.790129266558515*^9}, 3.7901294353860292`*^9, {3.790196227116281*^9, 
   3.790196237624302*^9}, 3.7901962856761436`*^9, {3.790196377141131*^9, 
   3.7901964526600723`*^9}},ExpressionUUID->"e2244b2b-7067-4b5a-b787-\
f07313bce9f9"],

Cell[BoxData[
 TemplateBox[{TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`t$$ = 0.8997201251983642, Typeset`show$$ = 
       True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`t$$], 0, 0.98}}, 
       Typeset`size$$ = {360., {118., 122.}}, Typeset`update$$ = 0, 
       Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`t$67500$$ = 0}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`t$$, $CellContext`t$67500$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Show[$CellContext`l1, $CellContext`l2, $CellContext`l4, 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{1, 0}, {1, 2.92}}], 
            Text[
             Style["a", 15], {1, -0.18}]}], 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{0, 3}, {0.95, 3}}], 
            Text["L\!\(\*\nStyleBox[\"-\",\nFontSize->12]\)", {-0.1, 3.2}]}], 
          
          Graphics[{Thick, Dotted, Red, 
            Line[{{$CellContext`t$$, 0}, {$CellContext`t$$, 
               $CellContext`f[$CellContext`t$$]}}], 
            Text["a-\[Epsilon]", {$CellContext`t$$ - 0.1, -0.25}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{0, 
               $CellContext`f[$CellContext`t$$]}, {$CellContext`t$$, 
               $CellContext`f[$CellContext`t$$]}}], 
            Text["f(a-\[Epsilon])", {-0.25, 
              $CellContext`f[$CellContext`t$$]}]}]], 
        "Specifications" :> {{$CellContext`t$$, 0, 0.98, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          DefaultBaseStyle -> "Animate", DefaultLabelStyle -> "AnimateLabel", 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}], ImageSizeCache -> {405., {154., 160.}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, SynchronousInitialization -> True, 
      UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Animate", Deployed -> True, 
     StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]],TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`t$$ = 0.965321159362793, Typeset`show$$ = 
       True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`t$$], 0, 0.98}}, 
       Typeset`size$$ = {360., {118., 123.}}, Typeset`update$$ = 0, 
       Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`t$67532$$ = 0}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`t$$, $CellContext`t$67532$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Show[$CellContext`r1, $CellContext`r2, $CellContext`r4, 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{1, 0}, {1, 2.92}}], 
            Text[
             Style["a", 15], {1, -0.18}]}], 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{1, 3.15}, {1, 6.9}}]}], 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{0, 7}, {0.95, 7}}], 
            Text["L\!\(\*\nStyleBox[\"+\",\nFontSize->12]\)", {-0.1, 6.8}]}], 
          
          Graphics[{Thick, Dotted, Red, 
            Line[{{2 - $CellContext`t$$, 0}, {2 - $CellContext`t$$, 
               $CellContext`f[2 - $CellContext`t$$]}}], 
            Text["a+\[Epsilon]", {2 - $CellContext`t$$ + 0.1, -0.25}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{0, 
               $CellContext`f[2 - $CellContext`t$$]}, {2 - $CellContext`t$$, 
               $CellContext`f[2 - $CellContext`t$$]}}], 
            Text["f(a+\[Epsilon])", {-0.25, 
              $CellContext`f[2 - $CellContext`t$$]}]}]], 
        "Specifications" :> {{$CellContext`t$$, 0, 0.98, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          DefaultBaseStyle -> "Animate", DefaultLabelStyle -> "AnimateLabel", 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}], ImageSizeCache -> {405., {155., 161.}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, SynchronousInitialization -> True, 
      UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Animate", Deployed -> True, 
     StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]],TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`t$$ = 0.9404744224548339, Typeset`show$$ = 
       True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`t$$], 0, 0.98}}, 
       Typeset`size$$ = {360., {131., 135.}}, Typeset`update$$ = 0, 
       Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`t$67557$$ = 0}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`t$$, $CellContext`t$67557$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Show[$CellContext`g1, $CellContext`g2, $CellContext`g4, 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{1, 0.1}, {1, 2.92}}], 
            Text[
             Style["a", 15], {1, -0.18}]}], 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{0, 3}, {0.95, 3}}], 
            Text["L\!\(\*\nStyleBox[\"-\",\nFontSize->12]\)", {-0.1, 3.2}]}], 
          
          Graphics[{Thick, Dotted, Purple, 
            Line[{{1, 3.15}, {1, 6.9}}], 
            Text["L\!\(\*\nStyleBox[\"+\",\nFontSize->12]\)", {-0.1, 6.8}]}], 
          
          Graphics[{Thick, Dotted, Purple, 
            Line[{{0, 7}, {0.95, 7}}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{2 - $CellContext`t$$, 0}, {2 - $CellContext`t$$, 
               $CellContext`f[2 - $CellContext`t$$]}}], 
            Text["a+\[Epsilon]", {2 - $CellContext`t$$ + 0.1, -0.25}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{0, 
               $CellContext`f[2 - $CellContext`t$$]}, {2 - $CellContext`t$$, 
               $CellContext`f[2 - $CellContext`t$$]}}], 
            Text["f(a+\[Epsilon])", {-0.25, 
              $CellContext`f[2 - $CellContext`t$$]}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{$CellContext`t$$, 0}, {$CellContext`t$$, 
               $CellContext`f[$CellContext`t$$]}}], 
            Text["a-\[Epsilon]", {$CellContext`t$$ - 0.1, -0.25}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{0, 
               $CellContext`f[$CellContext`t$$]}, {$CellContext`t$$, 
               $CellContext`f[$CellContext`t$$]}}], 
            Text["f(a-\[Epsilon])", {-0.25, 
              $CellContext`f[$CellContext`t$$]}]}]], 
        "Specifications" :> {{$CellContext`t$$, 0, 0.98, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          DefaultBaseStyle -> "Animate", DefaultLabelStyle -> "AnimateLabel", 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}], ImageSizeCache -> {405., {167., 173.}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, SynchronousInitialization -> True, 
      UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Animate", Deployed -> True, 
     StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]]},
  "RowDefault"]], "Output",
 CellChangeTimes->{{3.790126822643971*^9, 3.790126914978363*^9}, 
   3.790129118635737*^9, {3.790129167411647*^9, 3.790129189954279*^9}, {
   3.790129252478434*^9, 3.7901292685094643`*^9}, 3.790129416605978*^9, 
   3.790129449227871*^9, 3.790196139761546*^9, {3.79019627660938*^9, 
   3.790196288558091*^9}, 3.79019648998145*^9, 
   3.790196773968299*^9},ExpressionUUID->"fa08cc08-3614-40c0-9906-\
eca5e3d4bb15"],

Cell[BoxData["\<\"LimJumpDis.gif\"\>"], "Output",
 CellChangeTimes->{{3.790126822643971*^9, 3.790126914978363*^9}, 
   3.790129118635737*^9, {3.790129167411647*^9, 3.790129189954279*^9}, {
   3.790129252478434*^9, 3.7901292685094643`*^9}, 3.790129416605978*^9, 
   3.790129449227871*^9, 3.790196139761546*^9, {3.79019627660938*^9, 
   3.790196288558091*^9}, 3.79019648998145*^9, 
   3.790196774613071*^9},ExpressionUUID->"407d23e6-0e29-4fb9-ae0b-\
74f43fcd026a"]
}, Open  ]]
},
WindowSize->{1170, 755},
WindowMargins->{{Automatic, -51}, {Automatic, 0}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 22344, 554, 831, "Input", "ExpressionUUID" -> \
"e2244b2b-7067-4b5a-b787-f07313bce9f9"],
Cell[22927, 578, 9837, 189, 715, "Output", "ExpressionUUID" -> \
"fa08cc08-3614-40c0-9906-eca5e3d4bb15"],
Cell[32767, 769, 462, 7, 43, "Output", "ExpressionUUID" -> \
"407d23e6-0e29-4fb9-ae0b-74f43fcd026a"]
}, Open  ]]
}
]
*)

