(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     31046,        710]
NotebookOptionsPosition[     30486,        689]
NotebookOutlinePosition[     30840,        705]
CellTagsIndexPosition[     30797,        702]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "+", "2"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 

 RowBox[{
  RowBox[{"gifs2", " ", "=", " ", 
   RowBox[{"Row", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"l1", " ", "=", " ", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "2.5"}], ",", " ", "2"}], "}"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "2.5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", " ", 
          RowBox[{"PlotLabel", "\[Rule]", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<Limit of \\\"f(x)\\\" as \\\"x\\\" Approaches \\\"a\\\" From \
the Left\>\"", ",", " ", "Bold", ",", "15"}], "]"}]}], ",", 
          RowBox[{"Ticks", "->", "None"}]}], "]"}]}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"l2", " ", "=", " ", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "}"}], ",", "White", 
           ",", " ", 
           RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "}"}], "]"}]}], ";", 
       RowBox[{"Animate", "[", 
        RowBox[{
         RowBox[{"Show", "[", 
          RowBox[{"l1", ",", "l2", ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"1", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "2.92"}], "}"}]}], "}"}], "]"}], ",", " ", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<a\>\"", ",", "15"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"-", "0.25"}]}], "}"}]}], "]"}]}], "}"}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "3"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0.95", ",", "3"}], "}"}]}], "}"}], "]"}], ",", " ", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<L\!\(\*
StyleBox[\"-\",
FontSize->12]\)\>\"", ",", "15"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.1"}], ",", "3.2"}], "}"}]}], "]"}]}], "}"}],
             "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"t", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"t", ",", 
                   RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], ",",
               " ", 
              RowBox[{"Text", "[", 
               RowBox[{"\"\<a-\[Epsilon]\>\"", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"t", "-", "0.1"}], ",", 
                  RowBox[{"-", "0.25"}]}], "}"}]}], "]"}]}], "}"}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"f", "[", "t", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"t", ",", 
                   RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], ",",
               " ", 
              RowBox[{"Text", "[", 
               RowBox[{"\"\<f(a-\[Epsilon])\>\"", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.25"}], ",", 
                  RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "]"}]}], "}"}], 
            "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "0.98"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"r1", " ", "=", " ", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "2.5"}], ",", "2"}], "}"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "2.5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", " ", 
          RowBox[{"PlotLabel", "\[Rule]", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<Limit of \\\"f(x)\\\" as \\\"x\\\" Approaches \\\"a\\\" From \
the Right\>\"", ",", " ", "Bold", ",", "14"}], "]"}]}], ",", 
          RowBox[{"Ticks", "->", "None"}]}], "]"}]}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"r2", " ", "=", " ", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "}"}], ",", "White", 
           ",", " ", 
           RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "}"}], "]"}]}], ";", 
       RowBox[{"Animate", "[", 
        RowBox[{
         RowBox[{"Show", "[", 
          RowBox[{"r1", ",", "r2", ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"1", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "2.92"}], "}"}]}], "}"}], "]"}], ",", " ", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<a\>\"", ",", "15"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"-", "0.25"}]}], "}"}]}], "]"}]}], "}"}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "3"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0.95", ",", "3"}], "}"}]}], "}"}], "]"}], ",", " ", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<L\!\(\*
StyleBox[\"+\",
FontSize->12]\)\>\"", ",", "15"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.1"}], ",", "2.9"}], "}"}]}], "]"}]}], "}"}],
             "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"2", "-", "t"}], ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"2", "-", "t"}], ",", 
                   RowBox[{"f", "[", 
                    RowBox[{"2", "-", "t"}], "]"}]}], "}"}]}], "}"}], "]"}], 
              ",", " ", 
              RowBox[{"Text", "[", 
               RowBox[{"\"\<a+\[Epsilon]\>\"", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"2", "-", "t", "+", "0.1"}], ",", 
                  RowBox[{"-", "0.25"}]}], "}"}]}], "]"}]}], "}"}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"f", "[", 
                    RowBox[{"2", "-", "t"}], "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"2", "-", "t"}], ",", 
                   RowBox[{"f", "[", 
                    RowBox[{"2", "-", "t"}], "]"}]}], "}"}]}], "}"}], "]"}], 
              ",", " ", 
              RowBox[{"Text", "[", 
               RowBox[{"\"\<f(a+\[Epsilon])\>\"", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.25"}], ",", 
                  RowBox[{"f", "[", 
                   RowBox[{"2", "-", "t"}], "]"}]}], "}"}]}], "]"}]}], "}"}], 
            "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "0.98"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"g1", " ", "=", " ", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "2.5"}], ",", "2"}], "}"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "2.5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", " ", 
          RowBox[{"PlotLabel", "\[Rule]", 
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<Limit of \\\"f(x)\\\" as \\\"x\\\" Approaches \
\\\"a\\\"\\nThe Limit Exist\>\"", ",", " ", "Bold", ",", "15"}], "]"}]}], ",", 
          RowBox[{"Ticks", "->", "None"}]}], "]"}]}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"g2", " ", "=", " ", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "}"}], ",", "White", 
           ",", " ", 
           RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "}"}], "]"}]}], ";", 
       " ", 
       RowBox[{"Animate", "[", 
        RowBox[{
         RowBox[{"Show", "[", 
          RowBox[{"g1", ",", "g2", ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"1", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "2.92"}], "}"}]}], "}"}], "]"}], ",", " ", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<a\>\"", ",", "15"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"-", "0.25"}]}], "}"}]}], "]"}]}], "}"}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Purple", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "0.3"}], ",", "3"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0.95", ",", "3"}], "}"}]}], "}"}], "]"}], ",", " ", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<L\>\"", ",", "15"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.5"}], ",", "3"}], "}"}]}], "]"}]}], "}"}], 
            "]"}], ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"2", "-", "t"}], ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"2", "-", "t"}], ",", 
                   RowBox[{"f", "[", 
                    RowBox[{"2", "-", "t"}], "]"}]}], "}"}]}], "}"}], "]"}], 
              ",", " ", 
              RowBox[{"Text", "[", 
               RowBox[{"\"\<a+\[Epsilon]\>\"", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"2", "-", "t", "+", "0.1"}], ",", 
                  RowBox[{"-", "0.25"}]}], "}"}]}], "]"}]}], "}"}], "]"}], 
           ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"f", "[", 
                    RowBox[{"2", "-", "t"}], "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"2", "-", "t"}], ",", 
                   RowBox[{"f", "[", 
                    RowBox[{"2", "-", "t"}], "]"}]}], "}"}]}], "}"}], "]"}], 
              ",", " ", 
              RowBox[{"Text", "[", 
               RowBox[{"\"\<f(a+\[Epsilon])\>\"", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.25"}], ",", 
                  RowBox[{"f", "[", 
                   RowBox[{"2", "-", "t"}], "]"}]}], "}"}]}], "]"}]}], "}"}], 
            "]"}], ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"t", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"t", ",", 
                   RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], ",",
               " ", 
              RowBox[{"Text", "[", 
               RowBox[{"\"\<a-\[Epsilon]\>\"", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"t", "-", "0.1"}], ",", 
                  RowBox[{"-", "0.25"}]}], "}"}]}], "]"}]}], "}"}], "]"}], 
           ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Dotted", ",", "Red", ",", " ", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"f", "[", "t", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"t", ",", 
                   RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], ",",
               " ", 
              RowBox[{"Text", "[", 
               RowBox[{"\"\<f(a-\[Epsilon])\>\"", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.25"}], ",", 
                  RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "]"}]}], "}"}], 
            "]"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "0.98"}], "}"}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "}"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<LimDis.gif\>\"", ",", "gifs2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.7901269642548437`*^9, 3.790126970679097*^9}, {
  3.7901270521324797`*^9, 3.790127236162923*^9}, {3.790127285529833*^9, 
  3.7901273720858927`*^9}, {3.7901274028325644`*^9, 3.790127436280609*^9}, {
  3.7901274786291*^9, 3.790127752410555*^9}, {3.7901278983286743`*^9, 
  3.7901279220509977`*^9}, {3.790128068890748*^9, 3.7901281012464237`*^9}, {
  3.7901281338332167`*^9, 3.790128140628564*^9}, {3.790128213005302*^9, 
  3.790128243537386*^9}, {3.7901283055776987`*^9, 3.7901283625251713`*^9}, {
  3.790128441539507*^9, 3.790128469665592*^9}, {3.790128557440213*^9, 
  3.7901286662561502`*^9}, {3.7901286968867693`*^9, 3.7901288726101103`*^9}, {
  3.790128961310425*^9, 3.790129050398246*^9}, {3.7901964641680937`*^9, 
  3.7901964816818438`*^9}},ExpressionUUID->"694a65f4-b936-4f08-a9e5-\
04d5d5fd9029"],

Cell[BoxData[
 TemplateBox[{TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`t$$ = 0.7185842971801758, Typeset`show$$ = 
       True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`t$$], 0, 0.98}}, 
       Typeset`size$$ = {360., {118., 122.}}, Typeset`update$$ = 0, 
       Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`t$72927$$ = 0}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`t$$, $CellContext`t$72927$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Show[$CellContext`l1, $CellContext`l2, 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{1, 0}, {1, 2.92}}], 
            Text[
             Style["a", 15], {1, -0.25}]}], 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{0, 3}, {0.95, 3}}], 
            Text[
             Style["L\!\(\*\nStyleBox[\"-\",\nFontSize->12]\)", 15], {-0.1, 
             3.2}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{$CellContext`t$$, 0}, {$CellContext`t$$, 
               $CellContext`f[$CellContext`t$$]}}], 
            Text["a-\[Epsilon]", {$CellContext`t$$ - 0.1, -0.25}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{0, 
               $CellContext`f[$CellContext`t$$]}, {$CellContext`t$$, 
               $CellContext`f[$CellContext`t$$]}}], 
            Text["f(a-\[Epsilon])", {-0.25, 
              $CellContext`f[$CellContext`t$$]}]}]], 
        "Specifications" :> {{$CellContext`t$$, 0, 0.98, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          DefaultBaseStyle -> "Animate", DefaultLabelStyle -> "AnimateLabel", 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}], ImageSizeCache -> {405., {154., 160.}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, SynchronousInitialization -> True, 
      UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Animate", Deployed -> True, 
     StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]],TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`t$$ = 0.37470109939575197`, 
       Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
       Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
       1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`t$$], 0, 0.98}}, 
       Typeset`size$$ = {360., {118., 123.}}, Typeset`update$$ = 0, 
       Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`t$72944$$ = 0}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`t$$, $CellContext`t$72944$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Show[$CellContext`r1, $CellContext`r2, 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{1, 0}, {1, 2.92}}], 
            Text[
             Style["a", 15], {1, -0.25}]}], 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{0, 3}, {0.95, 3}}], 
            Text[
             Style["L\!\(\*\nStyleBox[\"+\",\nFontSize->12]\)", 15], {-0.1, 
             2.9}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{2 - $CellContext`t$$, 0}, {2 - $CellContext`t$$, 
               $CellContext`f[2 - $CellContext`t$$]}}], 
            Text["a+\[Epsilon]", {2 - $CellContext`t$$ + 0.1, -0.25}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{0, 
               $CellContext`f[2 - $CellContext`t$$]}, {2 - $CellContext`t$$, 
               $CellContext`f[2 - $CellContext`t$$]}}], 
            Text["f(a+\[Epsilon])", {-0.25, 
              $CellContext`f[2 - $CellContext`t$$]}]}]], 
        "Specifications" :> {{$CellContext`t$$, 0, 0.98, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          DefaultBaseStyle -> "Animate", DefaultLabelStyle -> "AnimateLabel", 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}], ImageSizeCache -> {405., {155., 161.}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, SynchronousInitialization -> True, 
      UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Animate", Deployed -> True, 
     StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]],TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`t$$ = 0.3375353889465332, Typeset`show$$ = 
       True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`t$$], 0, 0.98}}, 
       Typeset`size$$ = {360., {129., 133.}}, Typeset`update$$ = 0, 
       Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`t$72961$$ = 0}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`t$$, $CellContext`t$72961$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Show[$CellContext`g1, $CellContext`g2, 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{1, 0}, {1, 2.92}}], 
            Text[
             Style["a", 15], {1, -0.25}]}], 
          Graphics[{Thick, Dotted, Purple, 
            Line[{{-0.3, 3}, {0.95, 3}}], 
            Text[
             Style["L", 15], {-0.5, 3}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{2 - $CellContext`t$$, 0}, {2 - $CellContext`t$$, 
               $CellContext`f[2 - $CellContext`t$$]}}], 
            Text["a+\[Epsilon]", {2 - $CellContext`t$$ + 0.1, -0.25}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{0, 
               $CellContext`f[2 - $CellContext`t$$]}, {2 - $CellContext`t$$, 
               $CellContext`f[2 - $CellContext`t$$]}}], 
            Text["f(a+\[Epsilon])", {-0.25, 
              $CellContext`f[2 - $CellContext`t$$]}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{$CellContext`t$$, 0}, {$CellContext`t$$, 
               $CellContext`f[$CellContext`t$$]}}], 
            Text["a-\[Epsilon]", {$CellContext`t$$ - 0.1, -0.25}]}], 
          Graphics[{Thick, Dotted, Red, 
            Line[{{0, 
               $CellContext`f[$CellContext`t$$]}, {$CellContext`t$$, 
               $CellContext`f[$CellContext`t$$]}}], 
            Text["f(a-\[Epsilon])", {-0.25, 
              $CellContext`f[$CellContext`t$$]}]}]], 
        "Specifications" :> {{$CellContext`t$$, 0, 0.98, 
           AppearanceElements -> {
            "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
             "DirectionButton"}}}, 
        "Options" :> {
         ControlType -> Animator, AppearanceElements -> None, 
          DefaultBaseStyle -> "Animate", DefaultLabelStyle -> "AnimateLabel", 
          SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
        "DefaultOptions" :> {}], ImageSizeCache -> {405., {165., 171.}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, SynchronousInitialization -> True, 
      UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Animate", Deployed -> True, 
     StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]]},
  "RowDefault"]], "Output",
 CellChangeTimes->{
  3.7901269754698343`*^9, 3.790127098470188*^9, {3.790127134989105*^9, 
   3.79012716797116*^9}, 3.790127199543435*^9, 3.790127241403831*^9, 
   3.7901272943316*^9, {3.790127327399984*^9, 3.790127374841654*^9}, {
   3.790127410636602*^9, 3.790127438265325*^9}, {3.7901274805204077`*^9, 
   3.790127665106392*^9}, {3.7901277349206667`*^9, 3.790127755358962*^9}, {
   3.790127873764683*^9, 3.7901278895982924`*^9}, 3.79012793874298*^9, {
   3.790128103975235*^9, 3.790128143289483*^9}, {3.790128227424512*^9, 
   3.7901282452402763`*^9}, {3.790128311628109*^9, 3.790128326051673*^9}, {
   3.790128356520708*^9, 3.790128364275276*^9}, {3.790128453554389*^9, 
   3.7901284785142937`*^9}, {3.790128565320404*^9, 3.7901285810263968`*^9}, 
   3.790128637558506*^9, 3.790128668241085*^9, {3.790128717475559*^9, 
   3.790128749513637*^9}, {3.790128788001964*^9, 3.7901288744949017`*^9}, {
   3.790128977069738*^9, 3.790129051933217*^9}, 3.790129391851719*^9, 
   3.790196143770811*^9, {3.7901965735473347`*^9, 3.790196600702043*^9}, 
   3.790196836444615*^9},ExpressionUUID->"62529a3b-3027-46bd-91cb-\
ea1f3d42c341"],

Cell[BoxData["\<\"LimDis.gif\"\>"], "Output",
 CellChangeTimes->{
  3.7901269754698343`*^9, 3.790127098470188*^9, {3.790127134989105*^9, 
   3.79012716797116*^9}, 3.790127199543435*^9, 3.790127241403831*^9, 
   3.7901272943316*^9, {3.790127327399984*^9, 3.790127374841654*^9}, {
   3.790127410636602*^9, 3.790127438265325*^9}, {3.7901274805204077`*^9, 
   3.790127665106392*^9}, {3.7901277349206667`*^9, 3.790127755358962*^9}, {
   3.790127873764683*^9, 3.7901278895982924`*^9}, 3.79012793874298*^9, {
   3.790128103975235*^9, 3.790128143289483*^9}, {3.790128227424512*^9, 
   3.7901282452402763`*^9}, {3.790128311628109*^9, 3.790128326051673*^9}, {
   3.790128356520708*^9, 3.790128364275276*^9}, {3.790128453554389*^9, 
   3.7901284785142937`*^9}, {3.790128565320404*^9, 3.7901285810263968`*^9}, 
   3.790128637558506*^9, 3.790128668241085*^9, {3.790128717475559*^9, 
   3.790128749513637*^9}, {3.790128788001964*^9, 3.7901288744949017`*^9}, {
   3.790128977069738*^9, 3.790129051933217*^9}, 3.790129391851719*^9, 
   3.790196143770811*^9, {3.7901965735473347`*^9, 3.790196600702043*^9}, 
   3.790196837038258*^9},ExpressionUUID->"e9fc8941-17f9-4804-be8f-\
73ed56ebdf1b"]
}, Open  ]]
},
WindowSize->{1043, 755},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 18528, 450, 726, "Input", "ExpressionUUID" -> \
"694a65f4-b936-4f08-a9e5-04d5d5fd9029"],
Cell[19111, 474, 10183, 193, 711, "Output", "ExpressionUUID" -> \
"62529a3b-3027-46bd-91cb-ea1f3d42c341"],
Cell[29297, 669, 1173, 17, 43, "Output", "ExpressionUUID" -> \
"e9fc8941-17f9-4804-be8f-73ed56ebdf1b"]
}, Open  ]]
}
]
*)

