(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     20267,        485]
NotebookOptionsPosition[     19708,        464]
NotebookOutlinePosition[     20064,        480]
CellTagsIndexPosition[     20021,        477]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "[", 
   RowBox[{"a_", ",", "L_"}], "]"}], ":=", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"a", "+", "h"}], "]"}], "-", 
       RowBox[{"f", "[", "a", "]"}]}], ")"}], "/", 
     RowBox[{"(", "h", ")"}]}], ",", 
    RowBox[{"h", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"1", "-", "L"}], ")"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"l", "[", 
    RowBox[{"a_", ",", "L_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"m", "[", 
      RowBox[{"a", ",", "L"}], "]"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "a"}], ")"}]}], "+", 
    RowBox[{"f", "[", "a", "]"}]}]}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g1", " ", "=", " ", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "4.5"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.5"}], ",", "4.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.75"}], ",", "13"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
      RowBox[{"PlotLabels", "\[Rule]", 
       RowBox[{"Placed", "[", 
        RowBox[{"\"\<f(x)\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0.8", ",", "1"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Blue", ",", "Bold"}], "}"}]}], ",", 
      RowBox[{"Ticks", "->", "None"}]}], "]"}]}], ";"}], 
  "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", " ", "=", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"l", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "4.5"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "4.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.75"}], ",", "13"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Green"}], "}"}]}], ",", 
     RowBox[{"PlotLabels", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{"\"\<Tangent\\ny-f(a)=f '(a)(x-a)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"3.8", ",", "8.5"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Darker", "[", "Green", "]"}], ",", "Bold"}], "}"}]}], ",", 
     RowBox[{"Ticks", "->", "None"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"deriv1", "=", 
  RowBox[{"Animate", "[", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{"g2", ",", "g1", ",", "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"l", "[", 
         RowBox[{"2", ",", "t"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "1"}], ",", "4.5"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.5"}], ",", "4.5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.75"}], ",", "13"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thick", ",", "Dotted", ",", " ", "Red"}], "}"}]}], ",", 
        RowBox[{"PlotLabels", "\[Rule]", 
         RowBox[{"Placed", "[", 
          RowBox[{"\"\<Secant\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1.6", ",", "4.4"}], "}"}]}], "]"}]}], ",", " ", 
        RowBox[{"LabelStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Red", ",", "Bold"}], "}"}]}], ",", 
        RowBox[{"Ticks", "->", "None"}]}], "]"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Black", ",", " ", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<Limit of a Secant Line as \\\"x\\\" Approaches \\\"a\\\", \
\\nThe Tangent Line of \\\"f(x)\\\" at \\\"a\\\",\\nThe Slope at a Point \
\\\"a\\\"\>\"", ",", "Bold", ",", "13"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1.5", ",", "11.5"}], "}"}]}], "]"}]}], "}"}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"l", "[", 
         RowBox[{"2", ",", 
          RowBox[{"2", "-", "t"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "1"}], ",", "4.5"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.5"}], ",", "4.5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.75"}], ",", "13"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thick", ",", "Dotted", ",", " ", "Red"}], "}"}]}]}], "]"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Dotted", ",", "Purple", ",", " ", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3.95"}], "}"}]}], "}"}], "]"}], ",", " ", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<a\>\"", ",", "15"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"-", "0.2"}]}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Dotted", ",", "Purple", ",", " ", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "]"}], ",", " ", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<f(a)\>\"", ",", "15"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "0.25"}], ",", "4"}], "}"}]}], "]"}]}], "}"}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dotted", ",", "Black", ",", 
         RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"2", "+", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t"}], ")"}]}], ",", 
            RowBox[{"f", "[", 
             RowBox[{"2", "+", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t"}], ")"}]}], "]"}]}], "}"}], "]"}], ",", 
         " ", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<\!\(\*
StyleBox[\"(\",
FontSize->16]\)(a+h), f(a+h)\!\(\*
StyleBox[\")\",
FontSize->16]\)\>\"", ",", "10"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.5", "+", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t"}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"2", "+", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t"}], ")"}]}], "]"}], "-", "0.5"}]}], 
            "}"}]}], "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dotted", ",", "Black", ",", 
         RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"2", "-", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t"}], ")"}]}], ",", 
            RowBox[{"f", "[", 
             RowBox[{"2", "-", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t"}], ")"}]}], "]"}]}], "}"}], "]"}], ",", 
         " ", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<\!\(\*
StyleBox[\"(\",
FontSize->16]\)(a-h), f(a-h)\!\(\*
StyleBox[\")\",
FontSize->16]\)\>\"", ",", "10"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.5", "-", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t"}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"2", "-", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t"}], ")"}]}], "]"}], "-", "0.5"}]}], 
            "}"}]}], "]"}]}], "}"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"-", "1"}], ",", "1", ",", "0.1"}], "}"}], ",", 
    RowBox[{"AnimationRate", "\[Rule]", "0.1"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\</Users/Tuck/Documents/GradSchool/Year_2/Spring2020/Calc_I/Visuals/\
tangent_line.avi\>\"", ",", "deriv1"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7901269642548437`*^9, 3.790126970679097*^9}, {
   3.7901270521324797`*^9, 3.790127236162923*^9}, {3.790127285529833*^9, 
   3.7901273720858927`*^9}, {3.7901274028325644`*^9, 3.790127436280609*^9}, {
   3.7901274786291*^9, 3.790127752410555*^9}, {3.7901278983286743`*^9, 
   3.7901279220509977`*^9}, {3.790128068890748*^9, 3.7901281012464237`*^9}, {
   3.7901281338332167`*^9, 3.790128140628564*^9}, {3.790128213005302*^9, 
   3.790128243537386*^9}, {3.7901283055776987`*^9, 3.7901283625251713`*^9}, {
   3.790128441539507*^9, 3.790128469665592*^9}, {3.790128557440213*^9, 
   3.7901286662561502`*^9}, {3.7901286968867693`*^9, 
   3.7901288726101103`*^9}, {3.790128961310425*^9, 3.790129050398246*^9}, {
   3.7901964641680937`*^9, 3.7901964816818438`*^9}, {3.790373826910989*^9, 
   3.7903739872718287`*^9}, {3.79037404873977*^9, 3.7903741373400373`*^9}, {
   3.790374178572839*^9, 3.790374399821561*^9}, {3.7903744613305073`*^9, 
   3.790374658077999*^9}, {3.790374716471346*^9, 3.790374731907324*^9}, {
   3.790374779102436*^9, 3.790374788269227*^9}, {3.7903748295893717`*^9, 
   3.790374842961981*^9}, {3.790374880784588*^9, 3.790374949504559*^9}, {
   3.790374999046893*^9, 3.7903750914623947`*^9}, {3.790375121733014*^9, 
   3.790375125493568*^9}, {3.790375161614748*^9, 3.790375180130865*^9}, {
   3.790375260308495*^9, 3.790375345038413*^9}, 3.790375433598791*^9, 
   3.790375476991251*^9, {3.790375611701763*^9, 3.7903757368231688`*^9}, {
   3.790375768898286*^9, 3.790375838579468*^9}, {3.7903758712604313`*^9, 
   3.7903760575332003`*^9}, {3.790376094860094*^9, 3.790376117252076*^9}, {
   3.790376161992293*^9, 3.790376178679644*^9}, {3.790376213196723*^9, 
   3.790376245397015*^9}, {3.79037631791792*^9, 3.790376334894793*^9}, {
   3.790376367312193*^9, 3.790376473366152*^9}, {3.790376506436646*^9, 
   3.790376577266818*^9}, {3.790376752141899*^9, 3.790376864783703*^9}, {
   3.7903769092628736`*^9, 3.7903770456164913`*^9}, {3.79037707742136*^9, 
   3.790377083259207*^9}, {3.7903771159109793`*^9, 3.7903774245054817`*^9}, {
   3.790377472346217*^9, 3.7903775808274*^9}, {3.790377620068186*^9, 
   3.7903776991719646`*^9}, {3.790377972657425*^9, 3.790378136804652*^9}, {
   3.790378180745941*^9, 3.7903784289354353`*^9}, {3.790378511592669*^9, 
   3.7903785469671087`*^9}, {3.790378608322342*^9, 3.790378617244713*^9}, {
   3.790378879070006*^9, 3.790378879330402*^9}, {3.790378972466984*^9, 
   3.790379007687376*^9}, {3.7903818284317207`*^9, 3.790382025021002*^9}, {
   3.790382060020742*^9, 3.790382092010647*^9}, {3.7903821239578123`*^9, 
   3.790382128819272*^9}, {3.7903822303979063`*^9, 3.7903824169706793`*^9}, {
   3.7903824511516*^9, 3.7903824609450293`*^9}, {3.790382492061759*^9, 
   3.7903824957074003`*^9}, {3.7903826038373203`*^9, 
   3.7903827482770243`*^9}, {3.7903828020952253`*^9, 3.790382837775744*^9}, {
   3.790382875181291*^9, 3.7903829189530087`*^9}, {3.790383101538451*^9, 
   3.790383161476512*^9}, {3.7903832200877953`*^9, 3.7903832428552227`*^9}, {
   3.790383280655827*^9, 3.790383497187009*^9}, {3.790383535747723*^9, 
   3.7903835365743*^9}, {3.790383588372216*^9, 3.7903835910992327`*^9}, {
   3.790383701093528*^9, 3.790383840192293*^9}, {3.790383937855385*^9, 
   3.7903839829310503`*^9}, {3.790384498210761*^9, 3.790384571341372*^9}, {
   3.7903846060710707`*^9, 3.790384623265711*^9}, {3.790384764410026*^9, 
   3.7903847947744083`*^9}, {3.790384850135042*^9, 3.790384850916841*^9}, {
   3.790384922084991*^9, 3.790384982515476*^9}, {3.7903850524551*^9, 
   3.7903850604423733`*^9}, {3.790385172653718*^9, 3.790385282228149*^9}, {
   3.7903855836822567`*^9, 3.79038560105695*^9}, 3.790385756793271*^9, {
   3.790385881710658*^9, 3.7903858932121553`*^9}, {3.7903864294081173`*^9, 
   3.790386434473534*^9}, 3.7903881077463217`*^9, {3.790994625863562*^9, 
   3.790994633329261*^9}, 3.790994711490014*^9, 3.790994753868124*^9, {
   3.790994845421363*^9, 3.790994895647358*^9}, {3.790994938006234*^9, 
   3.790994938450775*^9}, 3.790995045901298*^9, 3.790995086799739*^9, {
   3.7909951459146633`*^9, 3.790995174695751*^9}, 3.79100114033521*^9, {
   3.791002819943554*^9, 3.7910028210330772`*^9}, {3.791002957792115*^9, 
   3.79100296066474*^9}},ExpressionUUID->"694a65f4-b936-4f08-a9e5-\
04d5d5fd9029"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0.30000000000000004`, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], -1, 1, 0.1}}, Typeset`size$$ = {
    360., {109., 114.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$865472$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = -1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$865472$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Show[$CellContext`g2, $CellContext`g1, 
        Plot[
         $CellContext`l[2, $CellContext`t$$], {$CellContext`x, -1, 4.5}, 
         PlotRange -> {{-0.5, 4.5}, {-0.75, 13}}, 
         PlotStyle -> {Thick, Dotted, Red}, PlotLabels -> 
         Placed["Secant", {1.6, 4.4}], LabelStyle -> {Red, Bold}, Ticks -> 
         None], 
        Graphics[{Black, 
          Text[
           Style[
           "Limit of a Secant Line as \"x\" Approaches \"a\", \nThe Tangent \
Line of \"f(x)\" at \"a\",\nThe Slope at a Point \"a\"", Bold, 13], {1.5, 
           11.5}]}], 
        Plot[
         $CellContext`l[2, 2 - $CellContext`t$$], {$CellContext`x, -1, 4.5}, 
         PlotRange -> {{-0.5, 4.5}, {-0.75, 13}}, 
         PlotStyle -> {Thick, Dotted, Red}], 
        Graphics[{Dotted, Purple, 
          Line[{{2, 0}, {2, 3.95}}], 
          Text[
           Style["a", 15], {2, -0.2}]}], 
        Graphics[{Dotted, Purple, 
          Line[{{0, 4}, {2, 4}}], 
          Text[
           Style["f(a)", 15], {-0.25, 4}]}], 
        Graphics[{Thick, Dotted, Black, 
          PointSize[Large], 
          Point[{2 + (1 - $CellContext`t$$), 
            $CellContext`f[2 + (1 - $CellContext`t$$)]}], 
          Text[
           Style[
           "\!\(\*\nStyleBox[\"(\",\nFontSize->16]\)(a+h), f(a+h)\!\(\*\n\
StyleBox[\")\",\nFontSize->16]\)", 10], {
           2.5 + (1 - $CellContext`t$$), $CellContext`f[
             2 + (1 - $CellContext`t$$)] - 0.5}]}], 
        Graphics[{Thick, Dotted, Black, 
          PointSize[Large], 
          Point[{2 - (1 - $CellContext`t$$), 
            $CellContext`f[2 - (1 - $CellContext`t$$)]}], 
          Text[
           Style[
           "\!\(\*\nStyleBox[\"(\",\nFontSize->16]\)(a-h), f(a-h)\!\(\*\n\
StyleBox[\")\",\nFontSize->16]\)", 10], {
           2.5 - (1 - $CellContext`t$$), $CellContext`f[
             2 - (1 - $CellContext`t$$)] - 0.5}]}]], 
      "Specifications" :> {{$CellContext`t$$, -1, 1, 0.1, AnimationRate -> 
         0.1, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, DefaultBaseStyle -> 
        "Animate", DefaultLabelStyle -> "AnimateLabel", SynchronousUpdating -> 
        True, ShrinkingDelay -> 10.}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {146., 152.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Animate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.7903849854592543`*^9, 3.790385205886839*^9, 
  3.790385246458741*^9, 3.790385321426302*^9, 3.790385433906886*^9, 
  3.7903856085561132`*^9, 3.7903857609401693`*^9, 3.790385901344943*^9, 
  3.790386443305976*^9, 3.790388117825511*^9, 3.790994572963485*^9, 
  3.7909946468229523`*^9, 3.7909947162256536`*^9, 3.790994757861443*^9, 
  3.790994867849777*^9, 3.790994909386801*^9, 3.790994954062317*^9, 
  3.790995049618692*^9, 3.790995160397068*^9, 3.7909952102838907`*^9, 
  3.791001145054659*^9, 3.791001966303939*^9, 3.791002831122971*^9, 
  3.791002963416047*^9},ExpressionUUID->"aed96a17-f0dd-42da-9fbc-\
6caf3474bc2e"],

Cell[BoxData["\<\"/Users/Tuck/Documents/GradSchool/Year_2/Spring2020/Calc_I/\
Visuals/tangent_line.avi\"\>"], "Output",
 CellChangeTimes->{3.7903849854592543`*^9, 3.790385205886839*^9, 
  3.790385246458741*^9, 3.790385321426302*^9, 3.790385433906886*^9, 
  3.7903856085561132`*^9, 3.7903857609401693`*^9, 3.790385901344943*^9, 
  3.790386443305976*^9, 3.790388117825511*^9, 3.790994572963485*^9, 
  3.7909946468229523`*^9, 3.7909947162256536`*^9, 3.790994757861443*^9, 
  3.790994867849777*^9, 3.790994909386801*^9, 3.790994954062317*^9, 
  3.790995049618692*^9, 3.790995160397068*^9, 3.7909952102838907`*^9, 
  3.791001145054659*^9, 3.791001966303939*^9, 3.791002831122971*^9, 
  3.7910029886904297`*^9},ExpressionUUID->"86cff0a7-e89b-495b-8d75-\
ece89cab8e16"]
}, Open  ]]
},
WindowSize->{1043, 755},
WindowMargins->{{100, Automatic}, {Automatic, 0}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 13937, 332, 611, "Input", "ExpressionUUID" -> \
"694a65f4-b936-4f08-a9e5-04d5d5fd9029"],
Cell[14520, 356, 4407, 92, 326, "Output", "ExpressionUUID" -> \
"aed96a17-f0dd-42da-9fbc-6caf3474bc2e"],
Cell[18930, 450, 762, 11, 43, "Output", "ExpressionUUID" -> \
"86cff0a7-e89b-495b-8d75-ece89cab8e16"]
}, Open  ]]
}
]
*)

