(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     36009,        771]
NotebookOptionsPosition[     35289,        745]
NotebookOutlinePosition[     35664,        762]
CellTagsIndexPosition[     35621,        759]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "+", "2"}], ",", 
        RowBox[{"x", "<", 
         RowBox[{"-", "1"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"x", "^", "2"}]}], " ", "+", "6"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "<", "x", "<", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", 
         RowBox[{"Cos", "[", 
          RowBox[{"x", "-", "2"}], "]"}]}], ",", 
        RowBox[{"x", "\[GreaterEqual]", "2"}]}], "}"}]}], "}"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l1", " ", "=", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", " ", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", "7"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
     RowBox[{"GridLines", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", 
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3", ",", 
          "4", ",", "5", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3", ",", 
          "4", ",", "5", ",", "6"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l2", " ", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], "}"}], ",", 
      "White", ",", " ", 
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l3", " ", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "5"}], "}"}], "]"}]}], "}"}], ",", 
      "White", ",", " ", 
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "5"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l4", " ", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], "]"}]}], "}"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"l1", ",", "l2", ",", "l3", ",", "l4"}], "]"}]}], "Input",
 CellChangeTimes->{{3.790124162542844*^9, 3.7901242605969954`*^9}, {
   3.790124316017997*^9, 3.7901243750205193`*^9}, {3.790124410136588*^9, 
   3.790124531358658*^9}, {3.79012457135316*^9, 3.790124643309168*^9}, {
   3.790124676563085*^9, 3.790124679565681*^9}, {3.790124714343642*^9, 
   3.7901247905815487`*^9}, {3.790124858787827*^9, 3.790124929286392*^9}, {
   3.790124972008831*^9, 3.790124983949965*^9}, {3.7901250782882357`*^9, 
   3.790125109264875*^9}, {3.790125142095786*^9, 3.790125185725842*^9}, {
   3.790125244180264*^9, 3.790125342182581*^9}, {3.7901254015644093`*^9, 
   3.7901254216729794`*^9}, {3.790125486279212*^9, 3.7901255320143833`*^9}, {
   3.790125573532686*^9, 3.7901256972548227`*^9}, {3.790125727809984*^9, 
   3.7901257617874603`*^9}, 3.790125815746035*^9, {3.790125880466939*^9, 
   3.79012614482545*^9}, {3.790126249160885*^9, 3.790126271126306*^9}, {
   3.7901263351360207`*^9, 3.7901263554683847`*^9}, {3.790126472792341*^9, 
   3.790126495180019*^9}, {3.7901266019570312`*^9, 3.790126614530875*^9}, {
   3.7901266498194113`*^9, 3.7901266592756557`*^9}, {3.79012669951611*^9, 
   3.790126744869032*^9}, {3.790126791278348*^9, 3.790126913176094*^9}, {
   3.790129096033676*^9, 3.790129188403113*^9}, {3.7901292358883257`*^9, 
   3.790129266558515*^9}, 3.7901294353860292`*^9, {3.790196227116281*^9, 
   3.790196237624302*^9}, 3.7901962856761436`*^9, {3.790196377141131*^9, 
   3.7901964526600723`*^9}, {3.790389095886736*^9, 3.79038917646751*^9}, {
   3.790389206540761*^9, 3.790389209784835*^9}, {3.7903892447020617`*^9, 
   3.790389324391127*^9}, {3.790389361588422*^9, 3.790389415962276*^9}, {
   3.790389479195643*^9, 3.790390000754836*^9}, {3.7903900473891773`*^9, 
   3.790390135624833*^9}, {3.7903902516866083`*^9, 
   3.790390287848735*^9}},ExpressionUUID->"38c01d89-4a08-4f25-bf3e-\
579b89965cd9"],

Cell[BoxData[
 GraphicsBox[{{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAAAAAAAAAFMAAAAAAAAAIwNqLmYer
1RLAtBczD1erBcAcCmip9EIRwDgU0FLphQLAazUqBdscD8DWalQKtjn+v2M3
3qjDwwvAxm68UYeH978qeDr/bqQIwFTwdP7dSPG/od1TxHlBBcCEdk8R5wXl
v+eBFTxHGALAOA+s4DnC0L+6lShF6Fb9vzBSu9a9SMU/MOnZ9C+d9r+gLUwW
oMXiP3TwLSkXhPa/GB+krdH34j+494Fd/mr2v5AQ/EQDKuM/QQYqxsw49r9+
86tzZo7jP1Ijepdp1PW/XLkL0SxX5D91XRo6owv1vxZFy4u56OU/utFafxZ6
87+MXEoB0wvpP/7YrrP9YPO/BE6imAQ+6T9C4ALo5Efzv3w/+i82cOk/y+6q
ULMV879qIqpemdTpP9wL+yFQsfK/SOgJvF+d6j//RZvEiejxvwJ0yXbsLuw/
RE3v+HDP8b94ZSEOHmHsP4hUQy1YtvG/8FZ5pU+T7D8QY+uVJoTxv+A5KdSy
9+w/IoA7Z8Mf8b+8/4gxecDtP2aHj5uqBvG/NPHgyKry7T+qjuPPke3wv6zi
OGDcJO4/M52LOGC78L+axeiOP4nuP3ik32xHovC/ELdAJnG77j+8qzOhLonw
v4iomL2i7e4/RLrbCf1W8L94i0jsBVLvP66qpTnHO/C/pKq0jHGI7z8Ym29p
kSDwv9DJIC3dvu8/x/rQWB8a8L9yCl5OwcvvPzgTIlM=
         "]], 
        LineBox[CompressedData["
1:eJwVlXk01Vsbx0/mZHbO+VGvulKGSEpUVPvJmEI0yNBLhqSbmxISoi4hlIuI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         "]], LineBox[CompressedData["
1:eJwVl3lYjF8bx6eNoqiZaVfNNPiFpEKUODeioqJFlAqpJCVESkWUijbSjnZJ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         "]]},
       Annotation[#, 
        "Charting`Private`Tag$23039#1"]& ], {}}, {{}, {}, {}}}, {}, {}}, {
    {PointSize[Large], PointBox[{-1, 1}]}, 
    {GrayLevel[1], PointSize[Medium], PointBox[{-1, 1}]}}, {
    {PointSize[Large], PointBox[{-1, 5}]}, 
    {GrayLevel[1], PointSize[Medium], PointBox[{-1, 5}]}}, 
   {PointSize[Large], PointBox[{2, 2}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{{-4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6}, {-2, -1, 0, 1, 2, 3, 4, 
    5, 6}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-5, 7}, {-3, 7}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.790389437506806*^9, 3.790389489265319*^9, {3.790389519266857*^9, 
   3.790389541136245*^9}, {3.790389628838297*^9, 3.7903896680440817`*^9}, 
   3.790389698466544*^9, {3.7903897291168003`*^9, 3.790389772416409*^9}, {
   3.79038988163142*^9, 3.790389921571362*^9}, {3.7903899599825907`*^9, 
   3.790390002534029*^9}, 3.79039005627789*^9, 3.790390137265873*^9, 
   3.7903902905059032`*^9},ExpressionUUID->"544ffc15-d482-4441-b585-\
0c550b77a377"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], ":=", 
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"x", "^", "2"}]}], " ", "+", "6"}], ",", 
        RowBox[{"x", "<", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "2.5"}], ")"}], "x"}], "+", "6"}], ",", 
        RowBox[{"0", "<", "x", "<", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "x"}], "+", "2"}], ")"}]}], ",", 
        RowBox[{"2", "<", "x"}]}], "}"}]}], "}"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m1", " ", "=", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"g", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", " ", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", "7"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
     RowBox[{"GridLines", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", 
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3", ",", 
          "4", ",", "5", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3", ",", 
          "4", ",", "5", ",", "6"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m2", " ", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "6"}], "}"}], "]"}]}], "}"}], ",", "White", ",", 
      " ", 
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "6"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m3", " ", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], "]"}]}], "}"}], ",", "White", ",", 
      " ", 
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", " ", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m4", " ", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "]"}]}], "}"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m5", " ", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"m1", ",", "m2", ",", "m4", ",", "m5"}], "]"}]}], "Input",
 CellChangeTimes->{{3.790390333055561*^9, 3.790390832278228*^9}, {
  3.790390872603099*^9, 
  3.790390885870076*^9}},ExpressionUUID->"3fb5daac-2bdf-45ce-bb2a-\
67240cc1b845"],

Cell[BoxData[
 GraphicsBox[{{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwdxws01Hkfx/FxmUlujWnMTzrJKC2pVqWeCs2XXJdKspPqVGgTu8k9IsmT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         "]], LineBox[CompressedData["
1:eJwBwQI+/SFib1JlAgAAACsAAAACAAAAiMb60Fgfej9EY31orO8XQFMz2LyG
QZQ/gOMnL1zNF0C22VeCh3uaP2AkOi3LvRdADcDrI8RaoD9AZUwrOq4XQHFm
a+nElKY/AOdwJxiPF0AAALX/Y763PwDuAhiQEhdAx8zZijNTyD8A/Cb5fxkW
QGh42sdbK8k/mO5i1JwIFkAIJNsEhAPKPy/hnq+59xVASnvcftSzyz9exhZm
89UVQMwp33J1FM8/vJAG02aSFUBoQ3Kt2+rSP3gl5qxNCxVAbKB3lR2s2T/v
TqVgG/0TQDotwbJQl+M/3qEjyLbgEUACdhXcZBnwP34s5exB4AtABwxQgWLu
9j/38FveBFYDQFgnWsA2Cfc/0k6Pj3s0A0CqQmT/CiT3P6yswkDyEgNATnl4
fbNZ9z9eaCmj388CQJbmoHkExfc/xN/2Z7pJAkAmwfFxppv4P5DOkfFvPQFA
RXaTYupI+j9UWI8Jtkn+P5aRnaG+Y/o/CBT2a6MG/j/orKfgkn76P7zPXM6Q
w/0/jOO7Xju0+j8gRyqTaz39P9RQ5FqMH/s/8DXFHCEx/D9kKzVTLvb7P4gT
+y+MGPo/g+DWQ3Kj/T+4zmZWYuf1P965S214vP0/VK/C7tKo9T86k8CWftX9
P/CPHodDavU/8EWq6YoH/j8oUda3JO30P16rfY+ja/4/lNNFGefy8z+6hPK4
qYT+PzC0obFXtPM/FV5n4q+d/j/MlP1JyHXzP8wQUTW8z/4/AFa1eqn48j86
diTb1DP/P3DYJNxr/vE/lk+ZBNtM/z8IuYB03L/xP/EoDi7hZf8/pJncDE2B
8T+o2/eA7Zf/P9xalD0uBPE/BLVsqvOw/z94O/DVnsXwP1+O4dP5yf8/FBxM
bg+H8D+6Z1b9/+L/P7D8pwaASPA/OQUvp+Dl/z/wcgpeTkHwP53KXZA=
         "]], 
        LineBox[CompressedData["
1:eJwVUmc0Fg4fFY/s9dj7GREZZUTm76cUimRvyl4lhDREQ4OQmRVRJEJSQklW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         "]]},
       Annotation[#, 
        "Charting`Private`Tag$25189#1"]& ], {}}, {{}, {}, {}}}, {}, {}}, {
    {PointSize[Large], PointBox[{0, 6}]}, 
    {GrayLevel[1], PointSize[Medium], PointBox[{0, 6}]}}, 
   {PointSize[Large], PointBox[{2, 1}]}, 
   {PointSize[Large], PointBox[{0, 0}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{{-4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6}, {-2, -1, 0, 1, 2, 3, 4, 
    5, 6}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-5, 7}, {-3, 7}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.790390686730741*^9, 3.790390724672261*^9}, {
   3.7903907835163116`*^9, 3.79039079989835*^9}, 3.790390833574087*^9, 
   3.790390889973987*^9},ExpressionUUID->"b31ed69a-adb4-48f0-b239-\
e4296f912284"]
}, Open  ]]
},
WindowSize->{1170, 755},
WindowMargins->{{43, Automatic}, {Automatic, 0}},
Magnification->1.5,
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 5407, 136, 346, "Input", "ExpressionUUID" -> \
"38c01d89-4a08-4f25-bf3e-579b89965cd9"],
Cell[5990, 160, 14664, 260, 375, "Output", "ExpressionUUID" -> \
"544ffc15-d482-4441-b585-0c550b77a377"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20691, 425, 4025, 123, 377, "Input", "ExpressionUUID" -> \
"3fb5daac-2bdf-45ce-bb2a-67240cc1b845"],
Cell[24719, 550, 10554, 192, 375, "Output", "ExpressionUUID" -> \
"b31ed69a-adb4-48f0-b239-e4296f912284"]
}, Open  ]]
}
]
*)

